package org.thewonderlemming.c4plantuml.graphml.model.builder;

/**
 * Holds values for the &lt;for&gt; property of the &lt;key&gt; tag.
 *
 * @author thewonderlemming
 *
 */
public enum KeyFor {

    /**
     * The key is usable by any element of the GraphML.
     */
    ALL("all"),

    /**
     * The key is targeted at &lt;edge&gt; tags.
     */
    EDGE("edge"),

    /**
     * The key is targeted at &lt;graph&gt; tags..
     */
    GRAPH("graph"),

    /**
     * The key is targeted at &lt;node&gt; tags.
     */
    NODE("node");


    private final String value;


    private KeyFor(final String value) {
        this.value = value;
    }

    /**
     * Returns the value of the &lt;for&gt; property.
     *
     * @return the value of the for property.
     */
    public String getValue() {
        return this.value;
    }
}
