package org.thewonderlemming.c4plantuml.graphml.model.builder;

/**
 * This is a functional interface and can therefore be used as the assignment target for a lambda expression or method
 * reference.
 *
 * @author thewonderlemming
 *
 * @param <T> the type of the input of the function.
 * @param <U> the type of the result of the function.
 */
@FunctionalInterface
public interface WithAttrType<T, U> {

    /**
     * Takes an object of type T, processes it and returns a result of type U.
     *
     * @param value the parameter given to the function.
     * @return the results of the function.
     */
    U withAttrType(final T value);
}
