package org.thewonderlemming.c4plantuml.graphml.model.builder;

/**
 * This is a functional interface and can therefore be used as the assignment target for a lambda expression or method
 * reference.
 *
 * @author thewonderlemming
 *
 * @param <U> the type of the result of the function.
 */
@FunctionalInterface
public interface WithDirection<U> {

    /**
     * Calls the {@link FunctionalInterface} with a default "directed" string.
     *
     * @return the results of the function.
     */
    default U withDefaultDirection() {
        return withDirection("directed");
    }

    /**
     * Takes a string, processes it and returns a result of type U.
     *
     * @param value the parameter given to the function.
     * @return the results of the function.
     */
    U withDirection(final String value);
}
