package org.thewonderlemming.c4plantuml.graphml.parse;

/**
 * This is a functional interface and can therefore be used as the assignment target for a lambda expression or method
 * reference.
 *
 * @author thewonderlemming
 *
 * @param <U> the type of the result of the function.
 */
@FunctionalInterface
public interface WithDescription<U> {

    /**
     * Takes a string, processes it and returns a result of type U.
     *
     * @param description the parameter given to the function.
     * @return the results of the function.
     */
    U withDescription(final String description);
}
