package org.thewonderlemming.c4plantuml.graphml.parse;

import org.thewonderlemming.c4plantuml.graphml.model.EntityType;

/**
 * This is a functional interface and can therefore be used as the assignment target for a lambda expression or method
 * reference.
 *
 * @author thewonderlemming
 *
 * @param <U> the type of the result of the function.
 */
@FunctionalInterface
public interface WithEntityType<U> {

    /**
     * Takes a parameter of type {@link EntityType}, processes it and returns a result of type U.
     *
     * @param type the parameter given to the function.
     * @return the results of the function.
     */
    U withEntityType(final EntityType type);
}
