package org.thewonderlemming.c4plantuml.graphml.validation;

/**
 * This is a functional interface and can therefore be used as the assignment target for a lambda expression or method
 * reference.
 *
 * @author thewonderlemming
 *
 * @param <S1> the first value of the tuple.
 * @param <S2> the second value of the tuple.
 * @param <S3> the third value of the tuple.
 */
@FunctionalInterface
public interface TripleConsumer<S1, S2, S3> {

    /**
     * Takes a tuple of size 3 and processes it.
     *
     * @param value1 the first value of the tuple.
     * @param value2 the second value of the tuple.
     * @param value3 the third value of the tuple.
     */
    void accept(final S1 value1, final S2 value2, final S3 value3);
}
