/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.graphml;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import org.easymock.EasyMock;
import org.thewonderlemming.c4plantuml.testbed.graphml.model.GivenFromIndex;
import org.thewonderlemming.c4plantuml.testbed.graphml.model.GivenIndex;
import org.thewonderlemming.c4plantuml.testbed.graphml.model.GivenModel;
import org.thewonderlemming.c4plantuml.testbed.graphml.model.GivenToIndex;
import org.thewonderlemming.c4plantuml.testingutils.AbstractMockHelper;
import org.thewonderlemming.c4plantuml.testingutils.AndReturn;
import org.thewonderlemming.c4plantuml.testingutils.MockType;

public class ListMockHelper<T>
extends AbstractMockHelper<List<T>> {
    public static <T> ListMockHelper<T> setUpDefaultMock(List<T> mock) {
        return new ListMockHelper<T>(mock, MockType.DEFAULT);
    }

    public static <T> ListMockHelper<T> setUpNiceMock(List<T> mock) {
        return new ListMockHelper<T>(mock, MockType.NICE);
    }

    public static <T> ListMockHelper<T> setUpStrictMock(List<T> mock) {
        return new ListMockHelper<T>(mock, MockType.STRICT);
    }

    private ListMockHelper(List<T> mock, MockType mockType) {
        super(mock, mockType);
    }

    public ListMockHelper<T> notToContain(T value) {
        EasyMock.expect((Object)((List)this.getMock()).contains(EasyMock.eq(value))).andReturn((Object)false);
        return this;
    }

    public ListMockHelper<T> notToContainAll(Collection<T> values) {
        EasyMock.expect((Object)((List)this.getMock()).containsAll((Collection)EasyMock.eq(values))).andReturn((Object)false);
        return this;
    }

    public AndReturn<Boolean, ListMockHelper<T>> toAdd(T model) {
        return result -> {
            EasyMock.expect((Object)((List)this.getMock()).add(EasyMock.eq((Object)model))).andReturn(result);
            return this;
        };
    }

    public AndReturn<Boolean, ListMockHelper<T>> toAddAll(Collection<T> models) {
        return result -> {
            EasyMock.expect((Object)((List)this.getMock()).addAll((Collection)EasyMock.eq((Object)models))).andReturn(result);
            return this;
        };
    }

    public GivenModel<Collection<T>, AndReturn<Boolean, ListMockHelper<T>>> toAddAllAtIndex(int index) {
        return models -> results -> {
            EasyMock.expect((Object)((List)this.getMock()).addAll(EasyMock.eq((int)index), (Collection)EasyMock.eq((Object)models))).andReturn(results);
            return this;
        };
    }

    public GivenModel<T, ListMockHelper<T>> toAddAtIndex(int index) {
        return model -> {
            ((List)this.getMock()).add(EasyMock.eq((int)index), EasyMock.eq((Object)model));
            EasyMock.expectLastCall();
            return this;
        };
    }

    public ListMockHelper<T> toBeCleared() {
        ((List)this.getMock()).clear();
        EasyMock.expectLastCall();
        return this;
    }

    public AndReturn<T[], ListMockHelper<T>> toCallArrayGiven(T[] array) {
        return results -> {
            EasyMock.expect((Object)((List)this.getMock()).toArray(array)).andReturn(results);
            return this;
        };
    }

    public AndReturn<Integer, ListMockHelper<T>> toCallIndexOfGiven(T model) {
        return index -> {
            EasyMock.expect((Object)((List)this.getMock()).indexOf(EasyMock.eq((Object)model))).andReturn(index);
            return this;
        };
    }

    public AndReturn<Integer, ListMockHelper<T>> toCallLastIndexOfGiven(T model) {
        return index -> {
            EasyMock.expect((Object)((List)this.getMock()).lastIndexOf(EasyMock.eq((Object)model))).andReturn(index);
            return this;
        };
    }

    public ListMockHelper<T> toCallListIterator(ListIterator<T> iterator) {
        EasyMock.expect(((List)this.getMock()).listIterator()).andReturn(iterator);
        return this;
    }

    public AndReturn<ListIterator<T>, ListMockHelper<T>> toCallListIteratorWithIndex(int index) {
        return iterator -> {
            EasyMock.expect(((List)this.getMock()).listIterator(EasyMock.eq((int)index))).andReturn(iterator);
            return this;
        };
    }

    public GivenFromIndex<Integer, GivenToIndex<Integer, AndReturn<List<T>, ListMockHelper<T>>>> toCallSubList() {
        return fromIndex -> toIndex -> results -> {
            EasyMock.expect(((List)this.getMock()).subList((Integer)EasyMock.eq((Object)fromIndex), (Integer)EasyMock.eq((Object)toIndex))).andReturn(results);
            return this;
        };
    }

    public ListMockHelper<T> toContain(T value) {
        EasyMock.expect((Object)((List)this.getMock()).contains(EasyMock.eq(value))).andReturn((Object)true);
        return this;
    }

    public ListMockHelper<T> toContainAll(Collection<T> values) {
        EasyMock.expect((Object)((List)this.getMock()).containsAll((Collection)EasyMock.eq(values))).andReturn((Object)true);
        return this;
    }

    public GivenIndex<Integer, ListMockHelper<T>> toGet(T model) {
        return index -> {
            EasyMock.expect(((List)this.getMock()).get((Integer)EasyMock.eq((Object)index))).andReturn(model);
            return this;
        };
    }

    public AndReturn<Boolean, ListMockHelper<T>> toRemove(T object) {
        return results -> {
            EasyMock.expect((Object)((List)this.getMock()).remove(EasyMock.eq((Object)object))).andReturn(results);
            return this;
        };
    }

    public AndReturn<Boolean, ListMockHelper<T>> toRemoveAllGiven(Collection<T> values) {
        return results -> {
            EasyMock.expect((Object)((List)this.getMock()).removeAll((Collection)EasyMock.eq((Object)values))).andReturn(results);
            return this;
        };
    }

    public AndReturn<T, ListMockHelper<T>> toRemoveGivenIndex(int index) {
        return object -> {
            EasyMock.expect(((List)this.getMock()).remove(EasyMock.eq((int)index))).andReturn(object);
            return this;
        };
    }

    public AndReturn<Boolean, ListMockHelper<T>> toRetainAllGiven(Collection<T> values) {
        return results -> {
            EasyMock.expect((Object)((List)this.getMock()).retainAll((Collection)EasyMock.eq((Object)values))).andReturn(results);
            return this;
        };
    }

    public ListMockHelper<T> toReturnArray(Object[] array) {
        EasyMock.expect((Object)((List)this.getMock()).toArray()).andReturn((Object)array);
        return this;
    }

    public ListMockHelper<T> toReturnEmptyStream() {
        EasyMock.expect(((List)this.getMock()).stream()).andReturn(Stream.of(new Object[0])).anyTimes();
        return this;
    }

    public ListMockHelper<T> toReturnSize(int size) {
        EasyMock.expect((Object)((List)this.getMock()).size()).andReturn((Object)size);
        return this;
    }

    public ListMockHelper<T> toReturnStreamOf(T ... streams) {
        EasyMock.expect(((List)this.getMock()).stream()).andReturn(Stream.of(streams)).anyTimes();
        return this;
    }

    public GivenIndex<Integer, AndReturn<T, ListMockHelper<T>>> toSet(T element) {
        return index -> result -> {
            EasyMock.expect((Object)((List)this.getMock()).set((Integer)EasyMock.eq((Object)index), EasyMock.eq((Object)element))).andReturn(result);
            return this;
        };
    }
}

