/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.graphml;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.testbed.graphml.ReadFromXmlFile;
import org.thewonderlemming.c4plantuml.testingutils.TestBedUtils;

public class ReadFromXmlFileArgumentProvider
implements ArgumentsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadFromXmlFileArgumentProvider.class);

    public static String readXmlFile(String xmlPath) {
        Path expected = TestBedUtils.getResourceAsPath((String)xmlPath);
        StringBuilder expectedResults = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(expected.toFile())));){
            String line;
            while ((line = br.readLine()) != null) {
                expectedResults.append(line).append("\n");
            }
        }
        catch (IOException e) {
            String errMsg = String.format("Could not read content from file %s because of the following: %s", xmlPath, e.getMessage(), e);
            LOGGER.error(errMsg);
            throw new AssertionError(errMsg, e);
        }
        return expectedResults.toString();
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        Method testMethod = context.getRequiredTestMethod();
        Optional annotation = TestBedUtils.getAnnotation((Method)testMethod, ReadFromXmlFile.class);
        if (!annotation.isPresent()) {
            throw new AssertionError((Object)("Expected annotation " + ReadFromXmlFile.class.getName() + " to be present on test method " + testMethod.getName() + " in order to use that provider!"));
        }
        return Stream.of(((ReadFromXmlFile)annotation.get()).value()).map(ReadFromXmlFileArgumentProvider::readXmlFile).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

