/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.graphml.junit.testcase;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.thewonderlemming.c4plantuml.graphml.C4Graph;
import org.thewonderlemming.c4plantuml.testbed.graphml.ReadFromXmlFileArgumentProvider;
import org.thewonderlemming.c4plantuml.testbed.graphml.junit.testcase.ParseC4ToGraphML;
import org.thewonderlemming.c4plantuml.testingutils.TestBedUtils;
import org.thewonderlemming.c4plantuml.testingutils.testcase.SutTestCase;

public interface ParseC4ToGraphMLTestCase
extends SutTestCase<C4Graph> {
    default public Class<C4Graph> getSutType() {
        return C4Graph.class;
    }

    @TestFactory
    default public Collection<DynamicTest> parseC4ToGraphML() {
        if (null == this.retrieveAnnotations()) {
            Assertions.fail((String)String.format("Not yet implemented! retrieveAnotations method should not return null. Are you missing the %s annotation?", ParseC4ToGraphML.class.getName()));
        }
        return this.retrieveAnnotations().stream().map(annotation -> {
            Path expectedPath = TestBedUtils.getResourceAsPath((String)annotation.expectedXmlResult());
            String expectedResult = ReadFromXmlFileArgumentProvider.readXmlFile(annotation.expectedXmlResult());
            String testName = "shouldGenerateGraphML_matchingFile" + expectedPath.getFileName() + annotation.testId();
            return DynamicTest.dynamicTest((String)testName, () -> {
                List c4Files = Stream.of(annotation.c4SourceFiles()).map(TestBedUtils::getResourceAsPath).collect(Collectors.toList());
                Optional results = ((C4Graph)this.sut()).addAndProcessC4Files(c4Files).export();
                ((OptionalAssert)Assertions.assertThat((Optional)results).isNotEmpty()).hasValue((Object)expectedResult);
            });
        }).collect(Collectors.toList());
    }

    default public List<ParseC4ToGraphML> retrieveAnnotations() {
        return Stream.of(this.getClass().getAnnotationsByType(ParseC4ToGraphML.class)).collect(Collectors.toList());
    }
}

