/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.grammars.SourceType;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;
import org.thewonderlemming.c4plantuml.graphml.C4ErrorListener;
import org.thewonderlemming.c4plantuml.graphml.C4GraphParseTreeListener;
import org.thewonderlemming.c4plantuml.graphml.export.GraphMLModelExporter;
import org.thewonderlemming.c4plantuml.graphml.model.C4Keys;
import org.thewonderlemming.c4plantuml.graphml.model.GraphMLModel;

public class C4Graph {
    private static final Logger LOGGER = LoggerFactory.getLogger(C4Graph.class);
    private final Charset charset;
    private final boolean formatOutput;
    private final GraphMLModel model;
    private final C4GraphParseTreeListener parserTreeListener;
    private final boolean strictValidation;
    private final boolean validateOutput;

    private static Optional<ParseTree> createParseTree(Parser parser) {
        C4L1Parser.DiagramContext tree;
        if (parser instanceof C4L1Parser) {
            tree = ((C4L1Parser)parser).diagram();
        } else if (parser instanceof C4L2Parser) {
            tree = ((C4L2Parser)parser).diagram();
        } else if (parser instanceof C4L3Parser) {
            tree = ((C4L3Parser)parser).diagram();
        } else {
            return Optional.empty();
        }
        return Optional.of(tree);
    }

    private static int sortPathAlphabetically(Path left, Path right) {
        return String.CASE_INSENSITIVE_ORDER.compare(left.toString(), right.toString());
    }

    public C4Graph(Charset charset, boolean formatOutput) {
        this(charset, formatOutput, true, true, false);
    }

    public C4Graph(Charset charset, boolean formatOutput, boolean thrownOnParseError) {
        this(charset, formatOutput, true, true, thrownOnParseError);
    }

    public C4Graph(Charset charset, boolean formatOutput, boolean validateOutput, boolean strictValidation, boolean thrownOnParseError) {
        this.charset = charset;
        this.formatOutput = formatOutput;
        this.validateOutput = validateOutput;
        this.strictValidation = strictValidation;
        this.model = GraphMLModel.builder().withKeys(C4Keys.getC4Keys()).withoutGraphs().build();
        this.parserTreeListener = new C4GraphParseTreeListener(this.model, thrownOnParseError);
    }

    public C4Graph addAndProcessC4Files(List<Path> c4Files) {
        c4Files.stream().sorted(C4Graph::sortPathAlphabetically).forEach(this::processC4File);
        return this;
    }

    public Optional<String> export() throws Throwable {
        this.parserTreeListener.wrapUp();
        return GraphMLModelExporter.export(this.model, this.charset, this.formatOutput, this.validateOutput, this.strictValidation);
    }

    private void processC4File(Path c4File) {
        Optional optionalSourceType = SourceType.getSourceTypeFromFilename((Path)c4File);
        if (!optionalSourceType.isPresent()) {
            LOGGER.error("Cannot determine the C4 level from filename: {}. Skipping", (Object)c4File);
        }
        optionalSourceType.ifPresent(sourceType -> sourceType.createParser(c4File, this.charset, (BaseErrorListener)C4ErrorListener.getInstance()).ifPresent(parser -> C4Graph.createParseTree(parser).ifPresent(tree -> this.parserTreeListener.parseTree((ParseTree)tree, c4File))));
    }
}

