/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.graphml.validation.GraphMLValidator;
import org.thewonderlemming.c4plantuml.graphml.validation.ValidationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class CDataDocumentDecorator
implements Document {
    private static final String INDENT_AMOUNT_OUTPUT_PROPERTY = "{http://xml.apache.org/xslt}indent-amount";
    private static final Logger LOGGER = LoggerFactory.getLogger(CDataDocumentDecorator.class);
    private final Document document;

    public static CDataDocumentDecorator newInstance() throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        docBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        Document document = docBuilderFactory.newDocumentBuilder().newDocument();
        return CDataDocumentDecorator.newInstance(document);
    }

    public static CDataDocumentDecorator newInstance(Document decorated) {
        return new CDataDocumentDecorator(decorated);
    }

    private CDataDocumentDecorator(Document document) {
        this.document = document;
    }

    @Override
    public Node adoptNode(Node source) {
        return this.document.adoptNode(source);
    }

    @Override
    public Node appendChild(Node newChild) {
        return this.document.appendChild(newChild);
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.document.cloneNode(deep);
    }

    @Override
    public short compareDocumentPosition(Node other) {
        return this.document.compareDocumentPosition(other);
    }

    @Override
    public Attr createAttribute(String name) {
        return this.document.createAttribute(name);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    @Override
    public CDATASection createCDATASection(String data) {
        return this.document.createCDATASection(data);
    }

    @Override
    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    @Override
    public Element createElement(String tagName) {
        return this.document.createElement(tagName);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public EntityReference createEntityReference(String name) {
        return this.document.createEntityReference(name);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return this.document.createProcessingInstruction(target, data);
    }

    @Override
    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> exportAsString(Charset charset, boolean indent, boolean validate, boolean strictValidation) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer nullTransformer = transformerFactory.newTransformer();
            nullTransformer.setOutputProperty("indent", indent ? "yes" : "no");
            nullTransformer.setOutputProperty(INDENT_AMOUNT_OUTPUT_PROPERTY, indent ? "4" : "0");
            nullTransformer.setOutputProperty("encoding", charset.name());
            nullTransformer.setOutputProperty("standalone", "yes");
            nullTransformer.setOutputProperty("cdata-section-elements", "data");
            nullTransformer.transform(new DOMSource(this.document), new StreamResult(baos));
            String graphML = baos.toString(charset.name());
            LOGGER.debug("Current (yet to be validated) GraphML:\n{}", (Object)graphML);
            if (validate) {
                try (ByteArrayInputStream bais = new ByteArrayInputStream(graphML.getBytes());){
                    GraphMLValidator.validate(bais, strictValidation);
                }
            }
            Optional<String> optional = Optional.of(graphML);
            return optional;
        }
        catch (IOException | TransformerException | ValidationException e) {
            LOGGER.error("Cannot process the current DOM document because of the following: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    @Override
    public String getBaseURI() {
        return this.document.getBaseURI();
    }

    @Override
    public NodeList getChildNodes() {
        return this.document.getChildNodes();
    }

    @Override
    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    @Override
    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    @Override
    public String getDocumentURI() {
        return this.document.getDocumentURI();
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.document.getDomConfig();
    }

    @Override
    public Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return this.document.getElementsByTagName(tagname);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.document.getFeature(feature, version);
    }

    @Override
    public Node getFirstChild() {
        return this.document.getFirstChild();
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    @Override
    public String getInputEncoding() {
        return this.document.getInputEncoding();
    }

    @Override
    public Node getLastChild() {
        return this.document.getLastChild();
    }

    @Override
    public String getLocalName() {
        return this.document.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    @Override
    public Node getNextSibling() {
        return this.document.getNextSibling();
    }

    @Override
    public String getNodeName() {
        return this.document.getNodeName();
    }

    @Override
    public short getNodeType() {
        return this.document.getNodeType();
    }

    @Override
    public String getNodeValue() {
        return this.document.getNodeValue();
    }

    @Override
    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    @Override
    public Node getParentNode() {
        return this.document.getParentNode();
    }

    @Override
    public String getPrefix() {
        return this.document.getPrefix();
    }

    @Override
    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.document.getStrictErrorChecking();
    }

    @Override
    public String getTextContent() {
        return this.document.getTextContent();
    }

    @Override
    public Object getUserData(String key) {
        return this.document.getUserData(key);
    }

    @Override
    public String getXmlEncoding() {
        return this.document.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.document.getXmlStandalone();
    }

    @Override
    public String getXmlVersion() {
        return this.document.getXmlVersion();
    }

    @Override
    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    @Override
    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) {
        return this.document.importNode(importedNode, deep);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        return this.document.insertBefore(newChild, refChild);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.document.isDefaultNamespace(namespaceURI);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return this.document.isEqualNode(arg);
    }

    @Override
    public boolean isSameNode(Node other) {
        return this.document.isSameNode(other);
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.document.lookupNamespaceURI(prefix);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.document.lookupPrefix(namespaceURI);
    }

    @Override
    public void normalize() {
        this.document.normalize();
    }

    @Override
    public void normalizeDocument() {
        this.document.normalizeDocument();
    }

    @Override
    public Node removeChild(Node oldChild) {
        return this.document.removeChild(oldChild);
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) {
        return this.document.renameNode(n, namespaceURI, qualifiedName);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        return this.document.replaceChild(newChild, oldChild);
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.document.setDocumentURI(documentURI);
    }

    @Override
    public void setNodeValue(String nodeValue) {
        this.document.setNodeValue(nodeValue);
    }

    @Override
    public void setPrefix(String prefix) {
        this.document.setPrefix(prefix);
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.document.setStrictErrorChecking(strictErrorChecking);
    }

    @Override
    public void setTextContent(String textContent) {
        this.document.setTextContent(textContent);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.document.setUserData(key, data, handler);
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) {
        this.document.setXmlStandalone(xmlStandalone);
    }

    @Override
    public void setXmlVersion(String xmlVersion) {
        this.document.setXmlVersion(xmlVersion);
    }
}

