/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.export;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.graphml.export.CDataDocumentDecorator;
import org.thewonderlemming.c4plantuml.graphml.model.GraphMLModel;
import org.w3c.dom.Node;

public class GraphMLModelExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphMLModelExporter.class);

    public static final Optional<String> export(GraphMLModel graphml) {
        return GraphMLModelExporter.export(graphml, StandardCharsets.UTF_8, false);
    }

    public static final Optional<String> export(GraphMLModel graphml, boolean formatOutput) {
        return GraphMLModelExporter.export(graphml, StandardCharsets.UTF_8, formatOutput);
    }

    public static final Optional<String> export(GraphMLModel graphml, Charset charset, boolean formatOutput) {
        return GraphMLModelExporter.export(graphml, charset, formatOutput, true, true);
    }

    public static final Optional<String> export(GraphMLModel graphml, Charset charset, boolean formatOutput, boolean validate, boolean strictValidation) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)GraphMLModel.class.getPackage().getName());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setEventHandler(event -> {
                LOGGER.debug("New event: {}", (Object)event.getMessage(), (Object)event.getLinkedException());
                return true;
            });
            CDataDocumentDecorator doc = CDataDocumentDecorator.newInstance();
            marshaller.setProperty("jaxb.formatted.output", (Object)formatOutput);
            marshaller.setProperty("jaxb.schemaLocation", (Object)"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.1/graphml.xsd");
            marshaller.setProperty("jaxb.encoding", (Object)charset.name());
            marshaller.marshal((Object)graphml, (Node)doc);
            return doc.exportAsString(charset, formatOutput, validate, strictValidation);
        }
        catch (JAXBException | ParserConfigurationException e) {
            LOGGER.error("Unable to export to GraphML format: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    private GraphMLModelExporter() {
    }
}

