/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.thewonderlemming.c4plantuml.graphml.model.KeyModel;
import org.thewonderlemming.c4plantuml.graphml.model.builder.KeyFor;

public enum C4Keys {
    ASPECT("attr00", KeyFor.GRAPH, "aspect", "string"),
    C4_LEVEL("attr01", KeyFor.EDGE, "c4_level", "string"),
    DESCRIPTION("attr02", KeyFor.NODE, "description", "string"),
    ENTITY_TYPE("attr03", KeyFor.NODE, "entity_type", "string"),
    LABEL("attr05", KeyFor.EDGE, "label", "string"),
    NAME("attr06", KeyFor.NODE, "name", "string"),
    PROTOCOL("attr07", KeyFor.EDGE, "protocol", "string"),
    TECHNOLOGICAL_STACK("attr08", KeyFor.NODE, "technological_stack", "string"),
    TITLE("attr09", KeyFor.GRAPH, "title", "string");

    private static final List<KeyModel> KEYS;
    private static final String STRING_TYPE = "string";
    private final String attrName;
    private final String attrType;
    private final String id;
    private final KeyFor keyFor;

    public static List<KeyModel> getC4Keys() {
        return Collections.unmodifiableList(KEYS);
    }

    private C4Keys(String id, KeyFor keyFor, String attrName, String attrType) {
        this.id = id;
        this.keyFor = keyFor;
        this.attrName = attrName;
        this.attrType = attrType;
    }

    public KeyModel getC4Key() {
        return KeyModel.builder().withId(this.id).withFor(this.keyFor).withAttrName(this.attrName).withAttrType(this.attrType).build();
    }

    public String getId() {
        return this.id;
    }

    static {
        KEYS = new ArrayList<KeyModel>();
        Stream.of(C4Keys.values()).forEach(value -> KEYS.add(value.getC4Key()));
    }
}

