/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.model;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.codec.digest.DigestUtils;
import org.thewonderlemming.c4plantuml.grammars.SourceType;
import org.thewonderlemming.c4plantuml.graphml.Build;
import org.thewonderlemming.c4plantuml.graphml.model.C4Keys;
import org.thewonderlemming.c4plantuml.graphml.model.CannotComputeEdgeModelId;
import org.thewonderlemming.c4plantuml.graphml.model.DataModel;
import org.thewonderlemming.c4plantuml.graphml.model.MappedListDecorator;
import org.thewonderlemming.c4plantuml.graphml.model.WithC4Level;
import org.thewonderlemming.c4plantuml.graphml.model.WithData;
import org.thewonderlemming.c4plantuml.graphml.model.WithLabel;
import org.thewonderlemming.c4plantuml.graphml.model.WithProtocol;
import org.thewonderlemming.c4plantuml.graphml.model.builder.WithId;
import org.thewonderlemming.c4plantuml.graphml.model.builder.WithSource;
import org.thewonderlemming.c4plantuml.graphml.model.builder.WithTarget;

@XmlRootElement(name="edge")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EdgeModel {
    public static final String TAG_NAME = "edge";
    @XmlElement(name="data", required=true)
    private MappedListDecorator<DataModel, String> data;
    @XmlAttribute(name="id", required=true)
    private String id;
    @XmlAttribute(name="source", required=true)
    private String source;
    @XmlAttribute(name="target", required=true)
    private String target;

    public static WithId<String, WithSource<String, WithTarget<String, WithData<Build<EdgeModel>>>>> builder() {
        return id -> source -> target -> data -> () -> {
            EdgeModel edge = new EdgeModel();
            edge.setId((String)id);
            edge.setSource((String)source);
            edge.setTarget((String)target);
            edge.setData(data);
            return edge;
        };
    }

    public static WithSource<String, WithTarget<String, WithLabel<WithProtocol<WithC4Level<String>>>>> generateIdFrom(String graphId) {
        return source -> target -> label -> protocol -> c4Level -> {
            try {
                String hashString = label + protocol;
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                String digested = new DigestUtils(digest).digestAsHex(hashString);
                return String.format("%s__%s__%s__%s__%s", graphId, source, target, c4Level, digested);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CannotComputeEdgeModelId(e);
            }
        };
    }

    private EdgeModel() {
    }

    public void addOrReplaceData(DataModel data) {
        this.data.addOrReplaceData(data);
    }

    public Optional<String> getC4Level() {
        return this.data.stream().filter(model -> model.getKey().equals(C4Keys.C4_LEVEL.getId())).map(DataModel::getValue).findFirst();
    }

    public List<DataModel> getData() {
        return this.data;
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getLabel() {
        return this.data.stream().filter(model -> model.getKey().equals(C4Keys.LABEL.getId())).map(DataModel::getValue).findFirst();
    }

    public Optional<String> getProtocol() {
        return this.data.stream().filter(model -> model.getKey().equals(C4Keys.PROTOCOL.getId())).map(DataModel::getValue).findFirst();
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setC4Level(SourceType c4Level) {
        this.addOrReplaceData(DataModel.builder().withKey(C4Keys.C4_LEVEL).withValue(c4Level.getC4Level()).build());
    }

    public void setLabel(String label) {
        this.addOrReplaceData(DataModel.builder().withKey(C4Keys.LABEL).withValue(label).build());
    }

    public void setProtocol(String protocol) {
        this.addOrReplaceData(DataModel.builder().withKey(C4Keys.PROTOCOL).withValue(protocol).build());
    }

    private void setData(List<DataModel> data) {
        this.data = new MappedListDecorator<DataModel, String>(DataModel.class, data, DataModel::getKey);
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setSource(String source) {
        this.source = source;
    }

    private void setTarget(String target) {
        this.target = target;
    }
}

