/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.model;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.thewonderlemming.c4plantuml.graphml.Build;
import org.thewonderlemming.c4plantuml.graphml.model.GraphModel;
import org.thewonderlemming.c4plantuml.graphml.model.KeyModel;
import org.thewonderlemming.c4plantuml.graphml.model.MappedListDecorator;
import org.thewonderlemming.c4plantuml.graphml.model.WithGraphs;
import org.thewonderlemming.c4plantuml.graphml.model.WithKeys;

@XmlRootElement(name="graphml")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GraphMLModel {
    public static final String NAMESPACE = "http://graphml.graphdrawing.org/xmlns";
    public static final String SCHEMA_LOCATION = "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.1/graphml.xsd";
    @XmlElement(name="key", required=true)
    private List<KeyModel> seq1Keys;
    @XmlElement(name="graph", required=true)
    private MappedListDecorator<GraphModel, String> seq2Graphs;

    public static WithKeys<WithGraphs<Build<GraphMLModel>>> builder() {
        return keys -> graphs -> () -> {
            GraphMLModel graphMl = new GraphMLModel();
            graphMl.setKeys(keys);
            graphMl.setGraphs(graphs);
            return graphMl;
        };
    }

    private GraphMLModel() {
    }

    public void addGraph(GraphModel graph) {
        this.seq2Graphs.addOrReplaceData(graph);
    }

    private void setGraphs(List<GraphModel> graphs) {
        this.seq2Graphs = new MappedListDecorator<GraphModel, String>(GraphModel.class, graphs, GraphModel::getId);
    }

    private void setKeys(List<KeyModel> keys) {
        this.seq1Keys = keys;
    }
}

