/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.model;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.thewonderlemming.c4plantuml.graphml.Build;
import org.thewonderlemming.c4plantuml.graphml.model.C4Keys;
import org.thewonderlemming.c4plantuml.graphml.model.DataModel;
import org.thewonderlemming.c4plantuml.graphml.model.EdgeModel;
import org.thewonderlemming.c4plantuml.graphml.model.MappedListDecorator;
import org.thewonderlemming.c4plantuml.graphml.model.NodeModel;
import org.thewonderlemming.c4plantuml.graphml.model.WithData;
import org.thewonderlemming.c4plantuml.graphml.model.WithEdges;
import org.thewonderlemming.c4plantuml.graphml.model.WithNodes;
import org.thewonderlemming.c4plantuml.graphml.model.builder.WithDirection;
import org.thewonderlemming.c4plantuml.graphml.model.builder.WithId;

@XmlRootElement(name="graph")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GraphModel {
    public static final String TAG_NAME = "graph";
    @XmlAttribute(name="edgedefault", required=true)
    private String edgeDefault;
    @XmlAttribute(name="id", required=true)
    private String id;
    @XmlElement(name="data")
    private MappedListDecorator<DataModel, String> seq1Data;
    @XmlElement(name="node")
    private MappedListDecorator<NodeModel, String> seq2Nodes;
    @XmlElement(name="edge")
    private MappedListDecorator<EdgeModel, String> seq3Edges;

    public static WithId<String, WithDirection<WithData<WithNodes<WithEdges<Build<GraphModel>>>>>> builder() {
        return id -> edgeDefault -> data -> nodes -> edges -> () -> {
            GraphModel graph = new GraphModel();
            graph.setId((String)id);
            graph.setEdgeDefault(edgeDefault);
            graph.setData(data);
            graph.setNodes(nodes);
            graph.setEdges(edges);
            return graph;
        };
    }

    private GraphModel() {
    }

    public void addOrReplaceData(DataModel data) {
        this.seq1Data.addOrReplaceData(data);
    }

    public void addOrReplaceEdge(EdgeModel edge) {
        this.seq3Edges.addOrReplaceData(edge);
    }

    public void addOrReplaceNode(NodeModel node) {
        this.seq2Nodes.addOrReplaceData(node);
    }

    public List<DataModel> getData() {
        return this.seq1Data;
    }

    public String getEdgeDefault() {
        return this.edgeDefault;
    }

    public List<EdgeModel> getEdges() {
        return this.seq3Edges;
    }

    public String getId() {
        return this.id;
    }

    public List<NodeModel> getNodes() {
        return this.seq2Nodes;
    }

    public boolean isChildOfNode(NodeModel node) {
        return this.id.equals(node.getId() + "::");
    }

    public boolean isEmpty() {
        return this.seq1Data.isEmpty() && this.seq2Nodes.isEmpty() && this.seq3Edges.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public void setAspect(String aspect) {
        this.addOrReplaceData(DataModel.builder().withKey(C4Keys.ASPECT).withValue(aspect).build());
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.addOrReplaceData(DataModel.builder().withKey(C4Keys.TITLE).withValue(title).build());
    }

    private void setData(List<DataModel> data) {
        this.seq1Data = new MappedListDecorator<DataModel, String>(DataModel.class, data, DataModel::getKey);
    }

    private void setEdgeDefault(String edgeDefault) {
        this.edgeDefault = edgeDefault;
    }

    private void setEdges(List<EdgeModel> edges) {
        this.seq3Edges = new MappedListDecorator<EdgeModel, String>(EdgeModel.class, edges, EdgeModel::getId);
    }

    private void setNodes(List<NodeModel> nodes) {
        this.seq2Nodes = new MappedListDecorator<NodeModel, String>(NodeModel.class, nodes, NodeModel::getId);
    }
}

