/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.model;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MappedListDecorator<M, K>
extends ArrayList<M>
implements List<M> {
    private static final long serialVersionUID = -7298751381485516154L;
    protected final transient Map<K, M> dataLookup = new HashMap<K, M>();
    private final transient List<M> decoratedList;
    private final transient Function<M, K> getModelId;
    private final Class<M> modelType;

    public MappedListDecorator(Class<M> modelType, List<M> model, Function<M, K> getModelId) {
        this.decoratedList = model;
        this.modelType = modelType;
        this.getModelId = getModelId;
        this.dataLookup.putAll(model.stream().map(d -> new AbstractMap.SimpleEntry(getModelId.apply(d), d)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @Override
    public void add(int index, M element) {
        this.decoratedList.add(index, element);
        this.dataLookup.put(this.getModelId.apply(element), element);
    }

    @Override
    public boolean add(M e) {
        boolean result = this.decoratedList.add(e);
        if (result) {
            this.dataLookup.put(this.getModelId.apply(e), e);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends M> c) {
        boolean result = this.decoratedList.addAll(c);
        if (result) {
            c.forEach((? super T item) -> {
                K key = this.getModelId.apply(item);
                this.dataLookup.put(key, item);
            });
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends M> c) {
        boolean result = this.decoratedList.addAll(index, c);
        if (result) {
            c.forEach((? super T item) -> {
                K key = this.getModelId.apply(item);
                this.dataLookup.put(key, item);
            });
        }
        return result;
    }

    public void addOrReplaceData(M model) {
        K key = this.getModelId.apply(model);
        if (this.dataLookup.containsKey(key)) {
            this.decoratedList.remove(this.dataLookup.get(key));
            this.dataLookup.remove(key);
        }
        this.add(model);
    }

    @Override
    public void clear() {
        this.decoratedList.clear();
        this.dataLookup.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.decoratedList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.decoratedList.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.decoratedList.equals(o);
    }

    @Override
    public M get(int index) {
        return this.decoratedList.get(index);
    }

    @Override
    public int hashCode() {
        return this.decoratedList.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.decoratedList.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.decoratedList.isEmpty();
    }

    @Override
    public Iterator<M> iterator() {
        return this.decoratedList.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.decoratedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<M> listIterator() {
        return this.decoratedList.listIterator();
    }

    @Override
    public ListIterator<M> listIterator(int index) {
        return this.decoratedList.listIterator(index);
    }

    @Override
    public M remove(int index) {
        M results = this.decoratedList.remove(index);
        K key = this.getModelId.apply(results);
        this.dataLookup.remove(key);
        return results;
    }

    @Override
    public boolean remove(Object o) {
        boolean results = this.decoratedList.remove(o);
        if (results && this.modelType.isAssignableFrom(o.getClass())) {
            K key = this.getModelId.apply(o);
            this.dataLookup.remove(key);
        }
        return results;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean results = this.decoratedList.removeAll(c);
        if (results) {
            c.stream().filter(item -> this.modelType.isAssignableFrom(item.getClass())).map(item -> item).forEach((? super T model) -> {
                K key = this.getModelId.apply(model);
                this.dataLookup.remove(key);
            });
        }
        return results;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean results = this.decoratedList.retainAll(c);
        if (results) {
            Set keys = c.stream().filter(item -> this.modelType.isAssignableFrom(item.getClass())).map(item -> item).map(this.getModelId::apply).collect(Collectors.toSet());
            Set<Object> toBeRemoved = this.dataLookup.keySet().stream().filter(key -> !keys.contains(key)).collect(Collectors.toSet());
            toBeRemoved.forEach(this.dataLookup::remove);
        }
        return results;
    }

    @Override
    public M set(int index, M element) {
        M results = this.decoratedList.set(index, element);
        K key = this.getModelId.apply(element);
        this.dataLookup.put(key, element);
        return results;
    }

    @Override
    public int size() {
        return this.decoratedList.size();
    }

    @Override
    public List<M> subList(int fromIndex, int toIndex) {
        return this.decoratedList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.decoratedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.decoratedList.toArray(a);
    }
}

