/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.parse;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.grammars.C4L1ParserListenerDecorator;
import org.thewonderlemming.c4plantuml.grammars.SourceType;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1ParserBaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1ParserListener;
import org.thewonderlemming.c4plantuml.graphml.model.CannotComputeEdgeModelId;
import org.thewonderlemming.c4plantuml.graphml.model.EdgeModel;
import org.thewonderlemming.c4plantuml.graphml.model.EntityType;
import org.thewonderlemming.c4plantuml.graphml.model.GraphModel;
import org.thewonderlemming.c4plantuml.graphml.model.NodeModel;
import org.thewonderlemming.c4plantuml.graphml.parse.WithDescription;
import org.thewonderlemming.c4plantuml.graphml.parse.WithEntityType;
import org.thewonderlemming.c4plantuml.graphml.parse.WithName;

public class C4L1GraphParseTreeListener
implements C4L1ParserListenerDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(C4L1GraphParseTreeListener.class);
    private final C4L1ParserBaseListener decorated = new C4L1ParserBaseListener();
    private final GraphModel graph;
    private final List<Throwable> unrecoverableErrors = new ArrayList<Throwable>();

    public C4L1GraphParseTreeListener() {
        this.graph = GraphModel.builder().withId("c4l1").withDefaultDirection().withoutData().withoutNodes().withoutEdges().build();
    }

    public void enterCloud(C4L1Parser.CloudContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L1 Cloud rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C1_CLOUD);
    }

    public void enterEveryRule(ParserRuleContext ctx) {
    }

    public void enterPerson(C4L1Parser.PersonContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L1 Person rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C1_PERSON);
    }

    public void enterPerson_ext(C4L1Parser.Person_extContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L1 PersonExt rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C1_PERSON_EXT);
    }

    public void enterRelationship(C4L1Parser.RelationshipContext ctx) {
        assert (ctx.Alias().size() == 2) : "Expected to find two aliases within C4L1 Relationship rule";
        String sourceAlias = ctx.Alias(0).getText();
        String targetAlias = ctx.Alias(1).getText();
        String label = ctx.String().getText();
        try {
            String edgeId = EdgeModel.generateIdFrom(this.graph.getId()).withSource(sourceAlias).withTarget(targetAlias).withLabel(label).withoutProtocol().withC4L1Level();
            EdgeModel relationshipEdge = EdgeModel.builder().withId(edgeId).withSource(this.graph.getId() + "::" + sourceAlias).withTarget(this.graph.getId() + "::" + targetAlias).withoutData().build();
            relationshipEdge.setC4Level(SourceType.C4_L1);
            relationshipEdge.setLabel(label);
            this.graph.addOrReplaceEdge(relationshipEdge);
        }
        catch (CannotComputeEdgeModelId e) {
            String errMsg = String.format("Cannot compute id for relationship '%s' -> '%s' = '%s' because of the following: %s", sourceAlias, targetAlias, label, e.getMessage());
            LOGGER.error(errMsg, (Throwable)e);
            this.unrecoverableErrors.add(new Exception(errMsg, e));
        }
    }

    public void enterSystem(C4L1Parser.SystemContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L1 System rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C1_SYSTEM);
    }

    public void enterSystem_ext(C4L1Parser.System_extContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L1 SystemExt rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C1_SYSTEM_EXT);
    }

    public void enterTitle(C4L1Parser.TitleContext ctx) {
        this.graph.setTitle(ctx.String(0).getText());
        if (ctx.String().size() > 1) {
            this.graph.setAspect(ctx.String(1).getText());
        }
    }

    public void exitEveryRule(ParserRuleContext ctx) {
    }

    public C4L1ParserListener getDecoratedC4L1ParserListener() {
        return this.decorated;
    }

    public GraphModel getGraph() {
        return this.graph;
    }

    public List<Throwable> getUnrecoverableErrors() {
        return this.unrecoverableErrors;
    }

    public void visitErrorNode(ErrorNode node) {
        LOGGER.debug("Parse errors are not handled there at this stage");
    }

    public void visitTerminal(TerminalNode node) {
    }

    private WithName<WithDescription<WithEntityType<Void>>> addNewNodeWithAlias(String alias) {
        return name -> description -> entityType -> {
            NodeModel node = NodeModel.builder().withId(this.graph.getId() + "::" + alias).withoutData().build();
            node.setName(name);
            node.setDescription(description);
            node.setEntityType(entityType);
            this.graph.addOrReplaceNode(node);
            return null;
        };
    }
}

