/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.grammars.C4L2ParserListenerDecorator;
import org.thewonderlemming.c4plantuml.grammars.SourceType;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2ParserBaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2ParserListener;
import org.thewonderlemming.c4plantuml.graphml.model.CannotComputeEdgeModelId;
import org.thewonderlemming.c4plantuml.graphml.model.EdgeModel;
import org.thewonderlemming.c4plantuml.graphml.model.EntityType;
import org.thewonderlemming.c4plantuml.graphml.model.GraphModel;
import org.thewonderlemming.c4plantuml.graphml.model.NodeModel;
import org.thewonderlemming.c4plantuml.graphml.parse.WithDescription;
import org.thewonderlemming.c4plantuml.graphml.parse.WithEntityType;
import org.thewonderlemming.c4plantuml.graphml.parse.WithName;

public class C4L2GraphParseTreeListener
implements C4L2ParserListenerDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(C4L2GraphParseTreeListener.class);
    private final Map<String, String> c4AliasToGraphAlias = new HashMap<String, String>();
    private final C4L2ParserBaseListener decorated = new C4L2ParserBaseListener();
    private final GraphModel graph;
    private final GraphModel systemBoundaryGraph;
    private final List<Throwable> unrecoverableErrors = new ArrayList<Throwable>();

    public C4L2GraphParseTreeListener() {
        this.graph = GraphModel.builder().withId("c4l2").withDefaultDirection().withoutData().withoutNodes().withoutEdges().build();
        this.systemBoundaryGraph = GraphModel.builder().withId("systemBoundary").withDefaultDirection().withoutData().withoutNodes().withoutEdges().build();
    }

    public void enterCloud(C4L2Parser.CloudContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L2 Cloud rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C2_CLOUD);
    }

    public void enterContainer(C4L2Parser.ContainerContext ctx) {
        assert (ctx.String().size() == 3) : "Expected to find two strings within C4L2 Container rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String technological_stack = ctx.String(1).getText();
        String description = ctx.String(2).getText();
        EntityType entityType = ctx.CONTAINER() != null ? EntityType.C2_CONTAINER : EntityType.C2_CONTAINER_DB;
        this.addNewContainerNodeWithAlias(alias, technological_stack).withName(name).withDescription(description).withEntityType(entityType);
    }

    public void enterEveryRule(ParserRuleContext ctx) {
    }

    public void enterPerson(C4L2Parser.PersonContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L2 Person rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C2_PERSON);
    }

    public void enterPerson_ext(C4L2Parser.Person_extContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L2 PersonExt rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C2_PERSON_EXT);
    }

    public void enterRelationship(C4L2Parser.RelationshipContext ctx) {
        assert (ctx.Alias().size() == 2) : "Expected to find two aliases within C4L2 Relationship rule";
        String sourceAlias = ctx.Alias(0).getText();
        String targetAlias = ctx.Alias(1).getText();
        String label = ctx.String(0).getText();
        String protocol = ctx.String().size() > 1 ? ctx.String(1).getText() : "";
        try {
            String edgeId = EdgeModel.generateIdFrom(this.graph.getId()).withSource(this.c4AliasToGraphAlias(sourceAlias)).withTarget(this.c4AliasToGraphAlias(targetAlias)).withLabel(label).withoutProtocol().withC4L2Level();
            EdgeModel relationshipEdge = EdgeModel.builder().withId(edgeId).withSource(this.c4AliasToGraphAlias(sourceAlias)).withTarget(this.c4AliasToGraphAlias(targetAlias)).withoutData().build();
            relationshipEdge.setC4Level(SourceType.C4_L2);
            relationshipEdge.setLabel(label);
            if (!protocol.isEmpty()) {
                relationshipEdge.setProtocol(protocol);
            }
            this.graph.addOrReplaceEdge(relationshipEdge);
        }
        catch (CannotComputeEdgeModelId e) {
            String errMsg = String.format("Cannot compute id for relationship '%s' -> '%s' = '%s' because of the following: %s", sourceAlias, targetAlias, label, e.getMessage());
            LOGGER.error(errMsg, (Throwable)e);
            this.unrecoverableErrors.add(new Exception(errMsg, e));
        }
    }

    public void enterSystem(C4L2Parser.SystemContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L2 System rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C2_SYSTEM);
    }

    public void enterSystem_boundary(C4L2Parser.System_boundaryContext ctx) {
        String alias = this.buildNodeAlias(ctx.Alias().getText());
        String name = ctx.String().getText();
        NodeModel systemBoundaryNode = NodeModel.builder().withId(alias).withoutData().build();
        this.systemBoundaryGraph.setId(alias + ":");
        this.systemBoundaryGraph.setTitle(name);
        systemBoundaryNode.setGraph(this.systemBoundaryGraph);
        this.graph.addOrReplaceNode(systemBoundaryNode);
    }

    public void enterSystem_ext(C4L2Parser.System_extContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L2 SystemExt rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C2_SYSTEM_EXT);
    }

    public void enterTitle(C4L2Parser.TitleContext ctx) {
        this.graph.setTitle(ctx.String(0).getText());
        if (ctx.String().size() > 1) {
            this.graph.setAspect(ctx.String(1).getText());
        }
    }

    public void exitEveryRule(ParserRuleContext ctx) {
    }

    public C4L2ParserListener getDecoratedC4L2ParserListener() {
        return this.decorated;
    }

    public GraphModel getGraph() {
        return this.graph;
    }

    public List<Throwable> getUnrecoverableErrors() {
        return this.unrecoverableErrors;
    }

    public void visitErrorNode(ErrorNode node) {
        LOGGER.debug("Parse errors are not handled there at this stage");
    }

    public void visitTerminal(TerminalNode node) {
    }

    private WithName<WithDescription<WithEntityType<Void>>> addNewContainerNodeWithAlias(String alias, String technologicalStack) {
        return name -> description -> entityType -> {
            NodeModel node = NodeModel.builder().withId(this.buildNodeAlias(alias, true)).withoutData().build();
            node.setName(name);
            node.setDescription(description);
            node.setEntityType(entityType);
            if (!technologicalStack.isEmpty()) {
                node.setTechnologicalStack(technologicalStack);
            }
            this.systemBoundaryGraph.addOrReplaceNode(node);
            return null;
        };
    }

    private WithName<WithDescription<WithEntityType<Void>>> addNewNodeWithAlias(String alias) {
        return name -> description -> entityType -> {
            NodeModel node = NodeModel.builder().withId(this.buildNodeAlias(alias)).withoutData().build();
            node.setName(name);
            node.setDescription(description);
            node.setEntityType(entityType);
            this.graph.addOrReplaceNode(node);
            return null;
        };
    }

    private String buildNodeAlias(String alias) {
        return this.buildNodeAlias(alias, false);
    }

    private String buildNodeAlias(String alias, boolean isContainer) {
        String fqAliasDelimiter = isContainer ? ":" : "::";
        String graphId = isContainer ? this.systemBoundaryGraph.getId() : this.graph.getId();
        String fqAlias = graphId + fqAliasDelimiter + alias;
        this.c4AliasToGraphAlias.put(alias, fqAlias);
        return fqAlias;
    }

    private String c4AliasToGraphAlias(String c4Alias) {
        return this.c4AliasToGraphAlias.get(c4Alias);
    }
}

