/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.grammars.C4L3ParserListenerDecorator;
import org.thewonderlemming.c4plantuml.grammars.SourceType;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3ParserBaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3ParserListener;
import org.thewonderlemming.c4plantuml.graphml.model.CannotComputeEdgeModelId;
import org.thewonderlemming.c4plantuml.graphml.model.EdgeModel;
import org.thewonderlemming.c4plantuml.graphml.model.EntityType;
import org.thewonderlemming.c4plantuml.graphml.model.GraphModel;
import org.thewonderlemming.c4plantuml.graphml.model.NodeModel;
import org.thewonderlemming.c4plantuml.graphml.parse.WithDescription;
import org.thewonderlemming.c4plantuml.graphml.parse.WithEntityType;
import org.thewonderlemming.c4plantuml.graphml.parse.WithName;

public class C4L3GraphParseTreeListener
implements C4L3ParserListenerDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(C4L3GraphParseTreeListener.class);
    private final Map<String, String> c4AliasToGraphAlias = new HashMap<String, String>();
    private GraphModel containerBoundaryGraph;
    private final C4L3ParserBaseListener decorated = new C4L3ParserBaseListener();
    private GraphModel graph;
    private final List<Throwable> unrecoverableErrors = new ArrayList<Throwable>();

    public C4L3GraphParseTreeListener() {
        this.reset(0);
    }

    public void enterCloud(C4L3Parser.CloudContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L3 Cloud rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C3_CLOUD);
    }

    public void enterComponent(C4L3Parser.ComponentContext ctx) {
        assert (ctx.String().size() == 3) : "Expected to find two strings within C4L3 Component rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String technological_stack = ctx.String(1).getText();
        String description = ctx.String(2).getText();
        EntityType entityType = ctx.COMPONENT() != null ? EntityType.C3_COMPONENT : EntityType.C3_COMPONENT_DB;
        this.addNewComponentNodeWithAlias(alias, technological_stack).withName(name).withDescription(description).withEntityType(entityType);
    }

    public void enterContainer(C4L3Parser.ContainerContext ctx) {
        assert (ctx.String().size() == 3) : "Expected to find two strings within C4L3 Container rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String technological_stack = ctx.String(1).getText();
        String description = ctx.String(2).getText();
        this.addNewNodeWithAlias(alias, technological_stack).withName(name).withDescription(description).withEntityType(EntityType.C3_CONTAINER);
    }

    public void enterContainer_boundary(C4L3Parser.Container_boundaryContext ctx) {
        String alias = this.buildNodeAlias(ctx.Alias().getText());
        String name = ctx.String().getText();
        NodeModel containerBoundaryNode = NodeModel.builder().withId(alias).withoutData().build();
        this.containerBoundaryGraph.setId(alias + ":");
        this.containerBoundaryGraph.setTitle(name);
        containerBoundaryNode.setGraph(this.containerBoundaryGraph);
        this.graph.addOrReplaceNode(containerBoundaryNode);
    }

    public void enterEveryRule(ParserRuleContext ctx) {
    }

    public void enterPerson(C4L3Parser.PersonContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L3 Person rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C3_PERSON);
    }

    public void enterPerson_ext(C4L3Parser.Person_extContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L3 PersonExt rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C3_PERSON_EXT);
    }

    public void enterRelationship(C4L3Parser.RelationshipContext ctx) {
        assert (ctx.Alias().size() == 2) : "Expected to find two aliases within C4L3 Relationship rule";
        String sourceAlias = ctx.Alias(0).getText();
        String targetAlias = ctx.Alias(1).getText();
        String label = ctx.String(0).getText();
        String protocol = ctx.String().size() > 1 ? ctx.String(1).getText() : "";
        try {
            String edgeId = EdgeModel.generateIdFrom(this.graph.getId()).withSource(this.c4AliasToGraphAlias(sourceAlias)).withTarget(this.c4AliasToGraphAlias(targetAlias)).withLabel(label).withoutProtocol().withC4L2Level();
            EdgeModel relationshipEdge = EdgeModel.builder().withId(edgeId).withSource(this.c4AliasToGraphAlias(sourceAlias)).withTarget(this.c4AliasToGraphAlias(targetAlias)).withoutData().build();
            relationshipEdge.setC4Level(SourceType.C4_L3);
            relationshipEdge.setLabel(label);
            if (!protocol.isEmpty()) {
                relationshipEdge.setProtocol(protocol);
            }
            this.graph.addOrReplaceEdge(relationshipEdge);
        }
        catch (CannotComputeEdgeModelId e) {
            String errMsg = String.format("Cannot compute id for relationship '%s' -> '%s' = '%s' because of the following: %s", sourceAlias, targetAlias, label, e.getMessage());
            LOGGER.error(errMsg, (Throwable)e);
            this.unrecoverableErrors.add(new Exception(errMsg, e));
        }
    }

    public void enterSystem(C4L3Parser.SystemContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L3 System rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C3_SYSTEM);
    }

    public void enterSystem_ext(C4L3Parser.System_extContext ctx) {
        assert (ctx.String().size() == 2) : "Expected to find two strings within C4L3 SystemExt rule";
        String alias = ctx.Alias().getText();
        String name = ctx.String(0).getText();
        String description = ctx.String(1).getText();
        this.addNewNodeWithAlias(alias).withName(name).withDescription(description).withEntityType(EntityType.C3_SYSTEM_EXT);
    }

    public void enterTitle(C4L3Parser.TitleContext ctx) {
        this.graph.setTitle(ctx.String(0).getText());
        if (ctx.String().size() > 1) {
            this.graph.setAspect(ctx.String(1).getText());
        }
    }

    public void exitEveryRule(ParserRuleContext ctx) {
    }

    public C4L3ParserListener getDecoratedC4L3ParserListener() {
        return this.decorated;
    }

    public GraphModel getGraph() {
        return this.graph;
    }

    public List<Throwable> getUnrecoverableErrors() {
        return this.unrecoverableErrors;
    }

    public void reset(int parentNodeId) {
        this.unrecoverableErrors.clear();
        this.graph = GraphModel.builder().withId("c4l3::" + Integer.toString(parentNodeId) + ":").withDefaultDirection().withoutData().withoutNodes().withoutEdges().build();
        this.containerBoundaryGraph = GraphModel.builder().withId("containerBoundary").withDefaultDirection().withoutData().withoutNodes().withoutEdges().build();
    }

    public void visitErrorNode(ErrorNode node) {
        LOGGER.debug("Parse errors are not handled there at this stage");
    }

    public void visitTerminal(TerminalNode node) {
    }

    private WithName<WithDescription<WithEntityType<Void>>> addNewComponentNodeWithAlias(String alias, String technologicalStack) {
        return name -> description -> entityType -> {
            NodeModel node = NodeModel.builder().withId(this.buildNodeAlias(alias, true)).withoutData().build();
            node.setName(name);
            node.setDescription(description);
            node.setEntityType(entityType);
            if (!technologicalStack.isEmpty()) {
                node.setTechnologicalStack(technologicalStack);
            }
            this.containerBoundaryGraph.addOrReplaceNode(node);
            return null;
        };
    }

    private WithName<WithDescription<WithEntityType<Void>>> addNewNodeWithAlias(String alias) {
        return this.addNewNodeWithAlias(alias, "");
    }

    private WithName<WithDescription<WithEntityType<Void>>> addNewNodeWithAlias(String alias, String technologicalStack) {
        return name -> description -> entityType -> {
            NodeModel node = NodeModel.builder().withId(this.buildNodeAlias(alias)).withoutData().build();
            node.setName(name);
            node.setDescription(description);
            node.setEntityType(entityType);
            if (!technologicalStack.isEmpty()) {
                node.setTechnologicalStack(technologicalStack);
            }
            this.graph.addOrReplaceNode(node);
            return null;
        };
    }

    private String buildNodeAlias(String alias) {
        return this.buildNodeAlias(alias, false);
    }

    private String buildNodeAlias(String alias, boolean isComponent) {
        String graphId = isComponent ? this.containerBoundaryGraph.getId() : this.graph.getId();
        String fqAlias = graphId + ":" + alias;
        this.c4AliasToGraphAlias.put(alias, fqAlias);
        return fqAlias;
    }

    private String c4AliasToGraphAlias(String c4Alias) {
        return this.c4AliasToGraphAlias.get(c4Alias);
    }
}

