/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.validation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.graphml.Build;
import org.thewonderlemming.c4plantuml.graphml.validation.WithBaseURI;
import org.thewonderlemming.c4plantuml.graphml.validation.WithPublicId;
import org.thewonderlemming.c4plantuml.graphml.validation.WithResourceFilename;
import org.thewonderlemming.c4plantuml.graphml.validation.WithSystemId;
import org.w3c.dom.ls.LSInput;

public class CustomLSInput
implements LSInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomLSInput.class);
    private static final int ONE_KBYTE = 1024;
    private String baseURI;
    private String publicId;
    private String resourceDataAsString;
    private String systemId;

    public static WithBaseURI<WithPublicId<WithResourceFilename<WithSystemId<Build<CustomLSInput>>>>> newBuilder() {
        return baseURI -> publicId -> resourceFilename -> systemId -> () -> new CustomLSInput(baseURI, publicId, resourceFilename, systemId);
    }

    private static final void printUnsupportedOperation(String methodName) {
        LOGGER.warn("Unsupported operation {}. The call will be ignored.", (Object)methodName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readResourceContentAsString(InputStream resourceStream) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = resourceStream.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            String string = baos.toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Unsupported encoding exception should not occur here with encoding 'UTF_8'!");
            return "";
        }
        catch (IOException e) {
            LOGGER.error("Could not retrieve the LSInput because of the following: {}", (Object)e.getMessage(), (Object)e);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readResourceContentAsString(String resourceFilename) {
        try (InputStream is = CustomLSInput.class.getResourceAsStream(resourceFilename);){
            String string = CustomLSInput.readResourceContentAsString(is);
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Could not retrieve the LSInput because of the following: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    private CustomLSInput(String baseURI, String publicId, String resourceFilename, String systemId) {
        this.baseURI = baseURI;
        this.publicId = publicId;
        this.systemId = systemId;
        this.resourceDataAsString = CustomLSInput.readResourceContentAsString(resourceFilename);
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public InputStream getByteStream() {
        return new ByteArrayInputStream(this.resourceDataAsString.getBytes());
    }

    @Override
    public boolean getCertifiedText() {
        CustomLSInput.printUnsupportedOperation("getCertifiedText");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Reader getCharacterStream() {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this.resourceDataAsString.getBytes());){
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bais, StandardCharsets.UTF_8);
            return inputStreamReader;
        }
        catch (IOException e) {
            LOGGER.error("Could not return character stream for {} because of the following: {}", new Object[]{this.publicId, e.getMessage(), e});
            return null;
        }
    }

    @Override
    public String getEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getStringData() {
        return this.resourceDataAsString;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public void setByteStream(InputStream byteStream) {
        try (BufferedInputStream bis = new BufferedInputStream(byteStream);){
            this.resourceDataAsString = bis.toString();
        }
        catch (IOException e) {
            LOGGER.error("Could not set byte stream because of the following: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void setCertifiedText(boolean certifiedText) {
        CustomLSInput.printUnsupportedOperation("setCertifiedText");
    }

    @Override
    public void setCharacterStream(Reader characterStream) {
        CustomLSInput.printUnsupportedOperation("setCharacterStream");
    }

    @Override
    public void setEncoding(String encoding) {
        CustomLSInput.printUnsupportedOperation("setEncoding");
    }

    @Override
    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    @Override
    public void setStringData(String stringData) {
        CustomLSInput.printUnsupportedOperation("setStringData");
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
}

