/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.validation;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.graphml.validation.CustomLSInput;
import org.thewonderlemming.c4plantuml.graphml.validation.GraphMLXsd;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class CustomResourceResolver
implements LSResourceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomResourceResolver.class);

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        Optional<GraphMLXsd> resolvedXsd = GraphMLXsd.resolveXsd(systemId, namespaceURI);
        if (!resolvedXsd.isPresent()) {
            LOGGER.warn("Could not resolve locally the resource matching the following arguments: type='{}', namespaceURI='{}', publicId='{}', systemId='{}', baseURI='{}'", new Object[]{type, namespaceURI, publicId, systemId, baseURI});
            return null;
        }
        return CustomLSInput.newBuilder().withBaseURI(baseURI).withPublicId(publicId).withResourceFilename(resolvedXsd.get().getResourceFilename()).withSystemId(systemId).build();
    }
}

