/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.validation;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.graphml.validation.CustomResourceResolver;
import org.thewonderlemming.c4plantuml.graphml.validation.GraphMLValidatorErrorHandler;
import org.thewonderlemming.c4plantuml.graphml.validation.ValidationException;
import org.xml.sax.SAXException;

public class GraphMLValidator {
    private static final String GRAPHML_XSD_FILENAME = "/graphml.xsd";
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphMLValidator.class);

    public static void validate(InputStream graphML, boolean strictValidation) throws ValidationException {
        GraphMLValidator.validate(new StreamSource(graphML), strictValidation);
    }

    public static void validate(StreamSource graphML, boolean strictValidation) throws ValidationException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setResourceResolver(new CustomResourceResolver());
            Schema schema = factory.newSchema(GraphMLValidator.getXsdAsStream(GRAPHML_XSD_FILENAME));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new GraphMLValidatorErrorHandler(strictValidation));
            validator.validate(graphML);
        }
        catch (IOException | SAXException e) {
            String errMsg = String.format("Cannot validate the GraphML stream because of the following: %s", e.getMessage());
            LOGGER.error(errMsg);
            throw new ValidationException(errMsg, e);
        }
    }

    private static StreamSource getXsdAsStream(String filename) {
        return new StreamSource(GraphMLValidator.class.getResourceAsStream(filename));
    }

    private GraphMLValidator() {
    }
}

