/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.validation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.graphml.validation.GraphMLValidator;
import org.thewonderlemming.c4plantuml.graphml.validation.TripleConsumer;
import org.thewonderlemming.c4plantuml.graphml.validation.ValidationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GraphMLValidatorErrorHandler
implements ErrorHandler {
    private final boolean strictValidation;

    public GraphMLValidatorErrorHandler(boolean strictValidation) {
        this.strictValidation = strictValidation;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.report(exception, (logger, msg, e) -> logger.error(msg, e));
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.report(exception, (logger, msg, e) -> logger.error(msg, e));
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.report(exception, (logger, msg, e) -> logger.warn(msg, e));
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(GraphMLValidator.class);
    }

    private void report(SAXParseException exception, TripleConsumer<Logger, String, Throwable> logger) throws SAXException {
        logger.accept(this.getLogger(), exception.getMessage(), exception);
        if (this.strictValidation) {
            throw new ValidationException(exception.getMessage(), exception);
        }
    }
}

