/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.graphml.validation;

import java.util.Optional;
import java.util.stream.Stream;

public enum GraphMLXsd {
    ATTRIBUTES("http://graphml.graphdrawing.org/xmlns/1.1/graphml-attributes.xsd", "/graphml-attributes.xsd", "http://graphml.graphdrawing.org/xmlns"),
    GRAPHML("http://graphml.graphdrawing.org/xmlns/1.1/graphml.xsd", "/graphml.xsd", "http://graphml.graphdrawing.org/xmlns"),
    PARSE_INFO("http://graphml.graphdrawing.org/xmlns/1.1/graphml-parseinfo.xsd", "/graphml-parseinfo.xsd", "http://graphml.graphdrawing.org/xmlns"),
    STRUCTURE("http://graphml.graphdrawing.org/xmlns/1.1/graphml-structure.xsd", "/graphml-structure.xsd", "http://graphml.graphdrawing.org/xmlns"),
    XLINK("http://graphml.graphdrawing.org/xmlns/1.1/xlink.xsd", "/xlink.xsd", "http://www.w3.org/1999/xlink");

    private static final String GRAPHML_NAMESPACE_URI = "http://graphml.graphdrawing.org/xmlns";
    private final String namespaceURI;
    private final String resourceFilename;
    private final String systemId;

    public static Optional<GraphMLXsd> resolveXsd(String systemId, String namespaceURI) {
        return Stream.of(GraphMLXsd.values()).filter(value -> value.matchesCurrentXsd(systemId, namespaceURI)).findAny();
    }

    private GraphMLXsd(String systemId, String resourceFilename, String namespaceUri) {
        this.resourceFilename = resourceFilename;
        this.systemId = systemId;
        this.namespaceURI = namespaceUri;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getResourceFilename() {
        return this.resourceFilename;
    }

    public String getSystemId() {
        return this.systemId;
    }

    private boolean matchesCurrentXsd(String systemId, String namespaceUri) {
        return this.systemId.equals(systemId) && this.namespaceURI.equals(namespaceUri);
    }
}

