package org.thewonderlemming.c4plantuml.linter;

import java.util.HashSet;
import java.util.Set;

import org.thewonderlemming.c4plantuml.linter.builder.AddLintingRule;
import org.thewonderlemming.c4plantuml.linter.builder.WithReporter;
import org.thewonderlemming.c4plantuml.linter.rules.AbstractLintingRule;

/**
 * A simple builder pattern to create {@link Linter} instances.
 *
 * @author thewonderlemming
 *
 */
public class LinterBuilder {

    /**
     * Returns a chain of method calls that ends with the build of a {@link Linter} instance.
     *
     * @return the next part of the method calls chain.
     */
    public WithReporter newLinter() {

        return reporter -> new AddLintingRule() {

            private final Set<AbstractLintingRule> lintingRules = new HashSet<>();

            @Override
            public AddLintingRule addLintingRule(final AbstractLintingRule lintingRule) {

                this.lintingRules.add(lintingRule);
                return this;
            }

            @Override
            public Linter build() {
                return new Linter(reporter, lintingRules);
            }
        };
    }
}
