package org.thewonderlemming.c4plantuml.linter.builder;

import java.util.Set;

import org.thewonderlemming.c4plantuml.linter.Linter;
import org.thewonderlemming.c4plantuml.linter.LinterBuilder;
import org.thewonderlemming.c4plantuml.linter.rules.AbstractLintingRule;

/**
 * A part of the {@link LinterBuilder} to add {@link AbstractLintingRule} and build a new {@link Linter} instance.
 *
 * @author thewonderlemming
 *
 */
public interface AddLintingRule {

    /**
     * Adds a {@link AbstractLintingRule} to the set of active rules.
     * <p>
     * Adding the same rule multiple times is not forbidden but in the end it will be part of a {@link Set}.
     *
     * @param lintingRule the {@link AbstractLintingRule} to add to the instance.
     * @return the current {@link AddLintingRule} builder instance.
     */
    AddLintingRule addLintingRule(final AbstractLintingRule lintingRule);

    /**
     * Adds a set of {@link AbstractLintingRule} to the set of active rules.
     *
     * @param lintingRules the {@link Set} of rules to add to the instance.
     * @return the current {@link AddLintingRule} builder instance.
     */
    default AddLintingRule addLintingRules(final Set<AbstractLintingRule> lintingRules) {

        lintingRules.forEach(this::addLintingRule);
        return this;
    }

    /**
     * Builds and returns the expected {@link Linter} instance.
     *
     * @return the new {@link Linter} instance.
     */
    Linter build();
}
