package org.thewonderlemming.c4plantuml.linter.builder;

import java.util.function.Function;

import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.linter.Linter;
import org.thewonderlemming.c4plantuml.linter.LinterBuilder;

/**
 * A basic Java {@link Function} to create the fluent {@link LinterBuilder}.
 *
 * @author thewonderlemming
 *
 */
@FunctionalInterface
public interface WithReporter {

    /**
     * Takes a {@link Reporter} and returns a method chain that ends with the build of a {@link Linter} instance.
     *
     * @param reporter the instance {@link Reporter}.
     * @return the next part of the method chain.
     */
    AddLintingRule withReporter(final Reporter reporter);
}
