package org.thewonderlemming.c4plantuml.linter.rules.builtin;

import java.util.Optional;

import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.linter.rules.RuleParameters;

/**
 * A linting rule that checks that aliases are not declared more than once. They can of course be used several times in
 * many relationships but only once as entities.
 *
 * @author thewonderlemming
 *
 */
public class AliasesShouldBeUniqueRule extends AbstractC4Rule {

    /**
     * Default constructor.
     * <p>
     * The {@link RuleParameters} object that is passed to the class is empty for now as there is no need for any
     * custom parameter.
     *
     * @param parameters the {@link RuleParameters} object that is being passed to the rule.
     */
    public AliasesShouldBeUniqueRule(final RuleParameters parameters) {
        super(parameters);
    }

    /**
     * {@inheritDoc}
     * <p>
     * Creates a {@link AliasesShouldBeUniqueListener} instance as a listener.
     */
    @Override
    public Optional<? extends ParseTreeListener> createParseTreeListener(final Reporter reporter,
        final Class<? extends Parser> parserType) {

        return this.acceptableParsersTypes().contains(parserType)
            ? Optional.of(new AliasesShouldBeUniqueListener(this, reporter))
            : Optional.empty();
    }
}
