package org.thewonderlemming.c4plantuml.linter.rules.builtin;

import java.util.Optional;

import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.linter.rules.RuleParameters;

/**
 * A linting rule that checks that relationships are not declared more than once. Two relationships would be identified
 * as identical if they shared the same source, target and label.
 *
 * @author thewonderlemming
 *
 */
public class NoDuplicateRelationshipsRule extends AbstractC4Rule {

    /**
     * Default constructor.
     * <p>
     * The {@link RuleParameters} object that is passed to the class is empty for now as there is no need for any
     * custom parameter.
     *
     * @param parameters the {@link RuleParameters} object that is being passed to the rule.
     */
    public NoDuplicateRelationshipsRule(final RuleParameters parameters) {
        super(parameters);
    }

    /**
     * {@inheritDoc}
     * <p>
     * Creates a {@link NoDuplicateRelationshipsListener} instance as a listener.
     */
    @Override
    public Optional<? extends ParseTreeListener> createParseTreeListener(final Reporter reporter,
        final Class<? extends Parser> parserType) {

        return this.acceptableParsersTypes().contains(parserType)
            ? Optional.of(new NoDuplicateRelationshipsListener(reporter))
            : Optional.empty();
    }
}
