package org.thewonderlemming.c4plantuml.linter.rules.builtin;

import java.util.Optional;

import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.linter.rules.RuleParameters;

/**
 * A linting rule that checks that the aliases used in a relationship are declared in the same source file as part of
 * any entity.
 *
 * @author thewonderlemming
 *
 */
public class NoOrphanAliasInRelationshipsRule extends AbstractC4Rule {

    private Optional<NoOrphanAliasInRelationshipsListener> wrapUpCallback = Optional.empty();


    /**
     * Default constructor.
     * <p>
     * The {@link RuleParameters} object that is passed to the class is empty for now as there is no need for any
     * custom parameter.
     *
     * @param parameters the {@link RuleParameters} object that is being passed to the rule.
     */
    public NoOrphanAliasInRelationshipsRule(final RuleParameters parameters) {
        super(parameters);
    }

    /**
     * {@inheritDoc}
     * <p>
     * Creates a {@link NoOrphanAliasInRelationshipsListener} instance as a listener.
     */
    @Override
    public Optional<? extends ParseTreeListener> createParseTreeListener(final Reporter reporter,
        final Class<? extends Parser> parserType) {

        this.wrapUpCallback = this.acceptableParsersTypes().contains(parserType)
            ? Optional.of(new NoOrphanAliasInRelationshipsListener(this, reporter))
            : Optional.empty();

        return this.wrapUpCallback;
    }

    /**
     * Verifies that the collected aliases in use in relationships are all declared.
     */
    @Override
    public void wrapUp() {
        this.wrapUpCallback.ifPresent(NoOrphanAliasInRelationshipsListener::checkThatNoAliasIsOrphanThenClearCollected);
    }
}
