/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.linter.rules.junit.testcase.lintsourcefile;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.commons.TestBedReporter;
import org.thewonderlemming.c4plantuml.linter.Linter;
import org.thewonderlemming.c4plantuml.linter.rules.AbstractLintingRule;
import org.thewonderlemming.c4plantuml.testbed.linter.rules.junit.testcase.lintsourcefile.LintSourceFile;
import org.thewonderlemming.c4plantuml.testbed.linter.rules.junit.testcase.lintsourcefile.LintSourceFileArgument;
import org.thewonderlemming.c4plantuml.testbed.linter.rules.junit.testcase.sut.SutLintingRuleTestCase;
import org.thewonderlemming.c4plantuml.testingutils.TestBedUtils;

public interface LintSourceFileLintingRuleTestCase
extends SutLintingRuleTestCase {
    default public List<LintSourceFileArgument> lintSourceFile() {
        return Stream.of(this.getClass().getAnnotationsByType(LintSourceFile.class)).map(lsf -> new LintSourceFileArgument(lsf.charsetAsString(), lsf.filename(), lsf.expectedReports())).collect(Collectors.toList());
    }

    @TestFactory
    default public Collection<DynamicTest> testLintSourceFile() {
        if (null == this.lintSourceFile()) {
            Assertions.fail((String)String.format("Not yet implemented! lintSourceFile() method should not return null. Are you missing the %s annotation?", LintSourceFile.class.getName()));
        }
        return this.lintSourceFile().stream().map(argument -> {
            TestBedReporter reporter = new TestBedReporter();
            Linter linter = Linter.builder().newLinter().withReporter((Reporter)reporter).addLintingRule((AbstractLintingRule)this.sut()).build();
            Path sourcePath = TestBedUtils.getResourceAsPath((String)argument.getFilename());
            Charset charset = argument.getCharset();
            String testName = String.format("shouldReport_asExpected_given-%s", argument.getFilename());
            return DynamicTest.dynamicTest((String)testName, () -> {
                linter.lint(sourcePath, charset);
                Assertions.assertThat((List)reporter.getReportedMessages()).containsExactlyElementsOf(argument.getExpectedReports());
            });
        }).collect(Collectors.toList());
    }
}

