/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.linter.rules.junit.testcase.selectparsetree;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.thewonderlemming.c4plantuml.grammars.SourceType;
import org.thewonderlemming.c4plantuml.linter.rules.AbstractLintingRule;
import org.thewonderlemming.c4plantuml.testbed.linter.fake.FakeGenericParser;
import org.thewonderlemming.c4plantuml.testbed.linter.rules.junit.testcase.selectparsetree.SelectParseTree;
import org.thewonderlemming.c4plantuml.testbed.linter.rules.junit.testcase.selectparsetree.SelectParseTreeArgument;
import org.thewonderlemming.c4plantuml.testbed.linter.rules.junit.testcase.sut.SutLintingRuleTestCase;
import org.thewonderlemming.c4plantuml.testingutils.TestBedUtils;

public interface SelectParseTreeLintingRuleTestCase
extends SutLintingRuleTestCase {
    default public <P extends Parser> P newParser(String filename, Charset charset, SourceType type, BaseErrorListener errorListener) {
        Path resource = TestBedUtils.getResourceAsPath((String)filename);
        Optional parser = type.createParser(resource, charset, errorListener);
        return (P)((Parser)parser.get());
    }

    default public Collection<SelectParseTreeArgument> selectParseTree() {
        return Stream.of(this.getClass().getAnnotationsByType(SelectParseTree.class)).map(parseTreeAnnotation -> new SelectParseTreeArgument(parseTreeAnnotation.charsetAsString(), parseTreeAnnotation.expectedParseTreeType(), parseTreeAnnotation.raiseAssertExceptionOnParsingError(), parseTreeAnnotation.sourceFilename(), parseTreeAnnotation.sourceType())).collect(Collectors.toList());
    }

    @TestFactory
    default public Collection<DynamicTest> testSelectParseTree() {
        if (null == this.selectParseTree()) {
            Assertions.fail((String)String.format("Not yet implemented! selectParseTree() method should not return null. Are you missing the %s annotation?", SelectParseTree.class.getName()));
        }
        Collection tests = this.selectParseTree().stream().map(argument -> DynamicTest.dynamicTest((String)("shouldReturnType" + argument.getExpectedParseTreeTypeName()), () -> {
            String filename = argument.getSourceFilename();
            Charset charset = argument.getCharset();
            SourceType type = argument.getSourceType();
            BaseErrorListener errorListener = argument.getBaseErrorListener();
            Object parser = this.newParser(filename, charset, type, errorListener);
            Optional results = ((AbstractLintingRule)this.sut()).selectParseTree(parser);
            if (argument.hasExpectedParseTreeType()) {
                ((OptionalAssert)Assertions.assertThat((Optional)results).isNotEmpty()).hasValueSatisfying(parseTreeType -> {
                    ClassAssert cfr_ignored_0 = (ClassAssert)Assertions.assertThat(parseTreeType.getClass()).hasSameClassAs(argument.getExpectedParseTreeType());
                });
            } else {
                Assertions.assertThat((Optional)results).isEmpty();
            }
        })).collect(Collectors.toList());
        tests.add(DynamicTest.dynamicTest((String)"shouldReturnNothing_givenUnsupportedParser", () -> Assertions.assertThat((Optional)((AbstractLintingRule)this.sut()).selectParseTree((Parser)new FakeGenericParser())).isEmpty()));
        return tests;
    }
}

