/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.linter.rules.builtin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.grammars.C4BaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.AliasesShouldFollowStandardConventionRule;

public class AliasesShouldFollowStandardConventionListener
extends C4BaseListener {
    private static final String MESSAGE_FORMAT = "Alias <%s> does not follow the expected conventions /%s/ in expression: <%s>";
    private final String aliasFormat;
    private final Pattern aliasFormatPattern;
    private final Reporter reporter;
    private final AliasesShouldFollowStandardConventionRule rule;

    public AliasesShouldFollowStandardConventionListener(AliasesShouldFollowStandardConventionRule rule, Reporter reporter, String aliasFormat) {
        this.aliasFormat = aliasFormat;
        this.aliasFormatPattern = Pattern.compile(aliasFormat);
        this.rule = rule;
        this.reporter = reporter;
    }

    public void enterBoundary(C4L1Parser.BoundaryContext ctx) {
        ctx.Alias().forEach(alias -> this.checkAliasFormat((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterBoundary(C4L2Parser.BoundaryContext ctx) {
        ctx.Alias().forEach(alias -> this.checkAliasFormat((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterBoundary(C4L3Parser.BoundaryContext ctx) {
        ctx.Alias().forEach(alias -> this.checkAliasFormat((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterCloud(C4L1Parser.CloudContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterCloud(C4L2Parser.CloudContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterCloud(C4L3Parser.CloudContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterComponent(C4L3Parser.ComponentContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterContainer(C4L2Parser.ContainerContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterContainer(C4L3Parser.ContainerContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterContainer_boundary(C4L3Parser.Container_boundaryContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterEnterprise_boundary(C4L1Parser.Enterprise_boundaryContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterEnterprise_boundary(C4L2Parser.Enterprise_boundaryContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterEnterprise_boundary(C4L3Parser.Enterprise_boundaryContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterLayout(C4L1Parser.LayoutContext ctx) {
        ctx.Alias().forEach(alias -> this.checkAliasFormat((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterLayout(C4L2Parser.LayoutContext ctx) {
        ctx.Alias().forEach(alias -> this.checkAliasFormat((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterLayout(C4L3Parser.LayoutContext ctx) {
        ctx.Alias().forEach(alias -> this.checkAliasFormat((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterPerson(C4L1Parser.PersonContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterPerson(C4L2Parser.PersonContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterPerson(C4L3Parser.PersonContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterPerson_ext(C4L1Parser.Person_extContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterPerson_ext(C4L2Parser.Person_extContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterPerson_ext(C4L3Parser.Person_extContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterRelationship(C4L1Parser.RelationshipContext ctx) {
        ctx.Alias().forEach(alias -> this.checkAliasFormat((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterRelationship(C4L2Parser.RelationshipContext ctx) {
        ctx.Alias().forEach(alias -> this.checkAliasFormat((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterRelationship(C4L3Parser.RelationshipContext ctx) {
        ctx.Alias().forEach(alias -> this.checkAliasFormat((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterSystem(C4L1Parser.SystemContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterSystem(C4L2Parser.SystemContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterSystem(C4L3Parser.SystemContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterSystem_boundary(C4L2Parser.System_boundaryContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterSystem_ext(C4L1Parser.System_extContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterSystem_ext(C4L2Parser.System_extContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    public void enterSystem_ext(C4L3Parser.System_extContext ctx) {
        this.checkAliasFormat(ctx.Alias(), (ParserRuleContext)ctx);
    }

    private void checkAliasFormat(TerminalNode alias, ParserRuleContext context) {
        Matcher matcher = this.aliasFormatPattern.matcher(alias.getText());
        if (!matcher.matches()) {
            String message = String.format(MESSAGE_FORMAT, alias.getText(), this.aliasFormat, context.getText());
            this.reporter.report(message);
            this.rule.getLogger().debug(message);
        }
    }
}

