/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.linter.rules.builtin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.grammars.C4BaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.NoOrphanAliasInBoundariesRule;

public class NoOrphanAliasInBoundariesListener
extends C4BaseListener {
    private static final String MESSAGE_FORMAT = "Alias <%s> is used in the boundary <'%s' -> '%s': '%s'> without being properly declared";
    private final Set<String> declaredAliases = new HashSet<String>();
    private final Reporter reporter;
    private final NoOrphanAliasInBoundariesRule rule;
    private final List<UsedAlias> usedAliases = new ArrayList<UsedAlias>();

    public NoOrphanAliasInBoundariesListener(NoOrphanAliasInBoundariesRule rule, Reporter reporter) {
        this.rule = rule;
        this.reporter = reporter;
    }

    public void checkThatNoAliasIsOrphanThenClearCollected() {
        this.usedAliases.forEach(usedAlias -> {
            if (!this.declaredAliases.contains(usedAlias.alias)) {
                String message = this.buildErrorMessageFromContext((UsedAlias)usedAlias);
                this.reporter.report(message);
            }
        });
        this.usedAliases.clear();
        this.declaredAliases.clear();
    }

    public void enterBoundary(C4L1Parser.BoundaryContext ctx) {
        ctx.Alias().forEach(alias -> this.collectUsedAlias((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterBoundary(C4L2Parser.BoundaryContext ctx) {
        ctx.Alias().forEach(alias -> this.collectUsedAlias((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterBoundary(C4L3Parser.BoundaryContext ctx) {
        ctx.Alias().forEach(alias -> this.collectUsedAlias((TerminalNode)alias, (ParserRuleContext)ctx));
    }

    public void enterCloud(C4L1Parser.CloudContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterCloud(C4L2Parser.CloudContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterCloud(C4L3Parser.CloudContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterComponent(C4L3Parser.ComponentContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterContainer(C4L2Parser.ContainerContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterContainer(C4L3Parser.ContainerContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterContainer_boundary(C4L3Parser.Container_boundaryContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterEnterprise_boundary(C4L1Parser.Enterprise_boundaryContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterEnterprise_boundary(C4L2Parser.Enterprise_boundaryContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterEnterprise_boundary(C4L3Parser.Enterprise_boundaryContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterPerson(C4L1Parser.PersonContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterPerson(C4L2Parser.PersonContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterPerson(C4L3Parser.PersonContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterPerson_ext(C4L1Parser.Person_extContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterPerson_ext(C4L2Parser.Person_extContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterPerson_ext(C4L3Parser.Person_extContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterSystem(C4L1Parser.SystemContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterSystem(C4L2Parser.SystemContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterSystem(C4L3Parser.SystemContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterSystem_boundary(C4L2Parser.System_boundaryContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterSystem_ext(C4L1Parser.System_extContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterSystem_ext(C4L2Parser.System_extContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    public void enterSystem_ext(C4L3Parser.System_extContext ctx) {
        this.collectDeclaredAlias(ctx.Alias());
    }

    private String buildErrorMessageFromC4L1Context(UsedAlias usedAlias) {
        C4L1Parser.BoundaryContext ctx = (C4L1Parser.BoundaryContext)usedAlias.context;
        String sourceAlias = ctx.Alias(0).getText();
        String targetAlias = ctx.Alias(1).getText();
        String description = ctx.String().getText();
        return String.format(MESSAGE_FORMAT, usedAlias.alias, sourceAlias, targetAlias, description);
    }

    private String buildErrorMessageFromC4L2Context(UsedAlias usedAlias) {
        C4L2Parser.BoundaryContext ctx = (C4L2Parser.BoundaryContext)usedAlias.context;
        String sourceAlias = ctx.Alias(0).getText();
        String targetAlias = ctx.Alias(1).getText();
        String description = ctx.String().getText();
        return String.format(MESSAGE_FORMAT, usedAlias.alias, sourceAlias, targetAlias, description);
    }

    private String buildErrorMessageFromC4L3Context(UsedAlias usedAlias) {
        C4L3Parser.BoundaryContext ctx = (C4L3Parser.BoundaryContext)usedAlias.context;
        String sourceAlias = ctx.Alias(0).getText();
        String targetAlias = ctx.Alias(1).getText();
        String description = ctx.String().getText();
        return String.format(MESSAGE_FORMAT, usedAlias.alias, sourceAlias, targetAlias, description);
    }

    private String buildErrorMessageFromContext(UsedAlias usedAlias) {
        if (usedAlias.context instanceof C4L1Parser.BoundaryContext) {
            return this.buildErrorMessageFromC4L1Context(usedAlias);
        }
        if (usedAlias.context instanceof C4L2Parser.BoundaryContext) {
            return this.buildErrorMessageFromC4L2Context(usedAlias);
        }
        if (usedAlias.context instanceof C4L3Parser.BoundaryContext) {
            return this.buildErrorMessageFromC4L3Context(usedAlias);
        }
        this.rule.getLogger().warn("The rule was unable to retrieve boundary information. Maybe the current source file is malformed?");
        return String.format(MESSAGE_FORMAT, usedAlias.alias, "?", "?", "?");
    }

    private void collectDeclaredAlias(TerminalNode alias) {
        this.declaredAliases.add(alias.getText());
    }

    private void collectUsedAlias(TerminalNode alias, ParserRuleContext context) {
        UsedAlias used = new UsedAlias(alias, context);
        this.usedAliases.add(used);
    }

    private class UsedAlias {
        public final String alias;
        public final ParserRuleContext context;

        public UsedAlias(TerminalNode alias, ParserRuleContext context) {
            this.alias = alias.getText();
            this.context = context;
        }
    }
}

