/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.linter;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.grammars.SourceType;
import org.thewonderlemming.c4plantuml.linter.LinterBuilder;
import org.thewonderlemming.c4plantuml.linter.LinterSyntaxErrorListener;
import org.thewonderlemming.c4plantuml.linter.rules.AbstractLintingRule;

public class Linter {
    private final Set<AbstractLintingRule> activeRules = new HashSet<AbstractLintingRule>();
    private final Reporter reporter;

    public static LinterBuilder builder() {
        return new LinterBuilder();
    }

    protected Linter(Reporter reporter, Set<AbstractLintingRule> activeRules) {
        this.reporter = reporter;
        this.activeRules.addAll(activeRules);
    }

    public Set<AbstractLintingRule> getActiveRules() {
        return Collections.unmodifiableSet(this.activeRules);
    }

    public void lint(Path c4SourceFile) {
        this.lint(c4SourceFile, StandardCharsets.UTF_8);
    }

    public void lint(Path c4SourceFile, Charset charset) {
        SourceType.getSourceTypeFromFilename((Path)c4SourceFile).ifPresent(sourceType -> {
            LinterSyntaxErrorListener errorListener = new LinterSyntaxErrorListener();
            sourceType.createParser(c4SourceFile, charset, (BaseErrorListener)errorListener).ifPresent(parser -> this.activeRules.stream().filter(rule -> rule.acceptableParsersTypes().contains(parser.getClass())).forEach(rule -> {
                errorListener.registerRule((AbstractLintingRule)rule);
                rule.selectParseTree((Parser)parser).ifPresent(tree -> {
                    rule.createParseTreeListener(this.reporter, parser.getClass()).ifPresent(listener -> new ParseTreeWalker().walk(listener, tree));
                    rule.wrapUp();
                });
                errorListener.unregisterRule((AbstractLintingRule)rule);
            }));
        });
    }
}

