/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.linter.rules;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleParameters.class);
    private final Map<String, String> parameters = new HashMap<String, String>();

    public static AddParameter builder() {
        return new AddParameter(){
            private final Map<String, String> parameters = new HashMap<String, String>();

            @Override
            public AddParameter addParameter(String name, String value) {
                this.parameters.put(name, value);
                return this;
            }

            @Override
            public RuleParameters build() {
                return new RuleParameters(this.parameters);
            }
        };
    }

    private RuleParameters(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }

    public Optional<String> getParameter(String parameterName) {
        return Optional.ofNullable(this.parameters.get(parameterName));
    }

    public Optional<Boolean> getParameterAsBoolean(String parameterName) {
        return this.getParameterAsType(parameterName, Boolean.class, value -> {
            if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                LOGGER.error("Error while parsing parameter {} as boolean: got {}", (Object)parameterName, value);
                return Optional.empty();
            }
            return Optional.ofNullable(Boolean.valueOf(value));
        });
    }

    public Optional<Integer> getParameterAsInteger(String parameterName) {
        return this.getParameterAsType(parameterName, Integer.class, value -> {
            try {
                Integer valueAsInt = Integer.parseInt(value);
                return Optional.ofNullable(valueAsInt);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Error while parsing parameter {} as integer: {}", new Object[]{parameterName, e.getMessage(), e});
                return Optional.empty();
            }
        });
    }

    public Optional<Long> getParameterAsLong(String parameterName) {
        return this.getParameterAsType(parameterName, Long.class, value -> {
            try {
                Long valueAsLong = Long.parseLong(value);
                return Optional.ofNullable(valueAsLong);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Error while parsing parameter {} as long: {}", new Object[]{parameterName, e.getMessage(), e});
                return Optional.empty();
            }
        });
    }

    public <T> Optional<T> getParameterAsType(String parameterName, Class<T> typeClass, Function<String, Optional<T>> typeConverter) {
        Optional<String> valueAsString = this.getParameter(parameterName);
        return valueAsString.isPresent() ? typeConverter.apply(valueAsString.get()) : Optional.empty();
    }

    public static interface AddParameter {
        public AddParameter addParameter(String var1, String var2);

        default public AddParameter addParameters(Map<String, String> values) {
            if (null != values) {
                values.forEach(this::addParameter);
            }
            return this;
        }

        public RuleParameters build();
    }
}

