/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.linter.rules.builtin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.grammars.C4BaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.AliasesShouldBeListedInDictionaryRule;

public class AliasesShouldBeListedInDictionaryListener
extends C4BaseListener {
    private static final String MESSAGE_FORMAT = "Alias <%s> was not found in the provided dictionary file: %s";
    private final Set<String> aliasDictionary = new HashSet<String>();
    private final String dictionaryFilename;
    private boolean isCheckEnabled = true;
    private final Reporter reporter;
    private final AliasesShouldBeListedInDictionaryRule rule;

    public AliasesShouldBeListedInDictionaryListener(AliasesShouldBeListedInDictionaryRule rule, Reporter reporter, String aliasDictionaryFilename) {
        this.rule = rule;
        this.reporter = reporter;
        this.dictionaryFilename = aliasDictionaryFilename;
        this.checkGivenFilenameAndPopulateDictionary(aliasDictionaryFilename);
    }

    public void enterBoundary(C4L1Parser.BoundaryContext ctx) {
        ctx.Alias().forEach(this::checkAliasExistsInDictionary);
    }

    public void enterBoundary(C4L2Parser.BoundaryContext ctx) {
        ctx.Alias().forEach(this::checkAliasExistsInDictionary);
    }

    public void enterBoundary(C4L3Parser.BoundaryContext ctx) {
        ctx.Alias().forEach(this::checkAliasExistsInDictionary);
    }

    public void enterCloud(C4L1Parser.CloudContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterCloud(C4L2Parser.CloudContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterCloud(C4L3Parser.CloudContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterComponent(C4L3Parser.ComponentContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterContainer(C4L2Parser.ContainerContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterContainer(C4L3Parser.ContainerContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterContainer_boundary(C4L3Parser.Container_boundaryContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterEnterprise_boundary(C4L1Parser.Enterprise_boundaryContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterEnterprise_boundary(C4L2Parser.Enterprise_boundaryContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterEnterprise_boundary(C4L3Parser.Enterprise_boundaryContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterLayout(C4L1Parser.LayoutContext ctx) {
        ctx.Alias().forEach(this::checkAliasExistsInDictionary);
    }

    public void enterLayout(C4L2Parser.LayoutContext ctx) {
        ctx.Alias().forEach(this::checkAliasExistsInDictionary);
    }

    public void enterLayout(C4L3Parser.LayoutContext ctx) {
        ctx.Alias().forEach(this::checkAliasExistsInDictionary);
    }

    public void enterPerson(C4L1Parser.PersonContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterPerson(C4L2Parser.PersonContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterPerson(C4L3Parser.PersonContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterPerson_ext(C4L1Parser.Person_extContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterPerson_ext(C4L2Parser.Person_extContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterPerson_ext(C4L3Parser.Person_extContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterRelationship(C4L1Parser.RelationshipContext ctx) {
        ctx.Alias().forEach(this::checkAliasExistsInDictionary);
    }

    public void enterRelationship(C4L2Parser.RelationshipContext ctx) {
        ctx.Alias().forEach(this::checkAliasExistsInDictionary);
    }

    public void enterRelationship(C4L3Parser.RelationshipContext ctx) {
        ctx.Alias().forEach(this::checkAliasExistsInDictionary);
    }

    public void enterSystem(C4L1Parser.SystemContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterSystem(C4L2Parser.SystemContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterSystem(C4L3Parser.SystemContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterSystem_boundary(C4L2Parser.System_boundaryContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterSystem_ext(C4L1Parser.System_extContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterSystem_ext(C4L2Parser.System_extContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    public void enterSystem_ext(C4L3Parser.System_extContext ctx) {
        this.checkAliasExistsInDictionary(ctx.Alias());
    }

    private void checkAliasExistsInDictionary(TerminalNode alias) {
        if (this.isCheckEnabled && !this.aliasDictionary.contains(alias.getText())) {
            String message = String.format(MESSAGE_FORMAT, alias.getText(), new File(this.dictionaryFilename).getName());
            this.reporter.report(message);
        }
    }

    private void checkGivenFilenameAndPopulateDictionary(String aliasDictionaryFilename) {
        if (aliasDictionaryFilename.trim().isEmpty()) {
            String message = "Aliases dictionary filename is empty. The current rule will be disabled.";
            this.reporter.report("Aliases dictionary filename is empty. The current rule will be disabled.");
            this.rule.getLogger().warn("Aliases dictionary filename is empty. The current rule will be disabled.");
            this.isCheckEnabled = false;
            return;
        }
        File dictionary = new File(aliasDictionaryFilename);
        if (dictionary.exists()) {
            this.populateAliasDictionaryFromFile(dictionary);
        } else {
            String message = String.format("Could not find expected dictionary: %s", dictionary.getName());
            this.reporter.report(message);
            this.rule.getLogger().error(message);
            this.isCheckEnabled = false;
        }
    }

    private void populateAliasDictionaryFromFile(File dictionary) {
        try (Stream<String> lines = Files.lines(dictionary.toPath());){
            lines.forEach(this.aliasDictionary::add);
        }
        catch (IOException e) {
            this.rule.getLogger().error("An error occurred while reading the aliases dictionary file: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

