/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.linter.rules.builtin;

import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.grammars.C4BaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;
import org.thewonderlemming.c4plantuml.linter.rules.builtin.AliasesShouldBeUniqueRule;

public class AliasesShouldBeUniqueListener
extends C4BaseListener {
    private final Set<String> aliases = new HashSet<String>();
    private final Reporter reporter;
    private final AliasesShouldBeUniqueRule rule;

    public AliasesShouldBeUniqueListener(AliasesShouldBeUniqueRule rule, Reporter reporter) {
        this.reporter = reporter;
        this.rule = rule;
    }

    public void enterCloud(C4L1Parser.CloudContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterCloud(C4L2Parser.CloudContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterCloud(C4L3Parser.CloudContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterComponent(C4L3Parser.ComponentContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterContainer(C4L2Parser.ContainerContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterContainer(C4L3Parser.ContainerContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterContainer_boundary(C4L3Parser.Container_boundaryContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterEnterprise_boundary(C4L1Parser.Enterprise_boundaryContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterEnterprise_boundary(C4L2Parser.Enterprise_boundaryContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterEnterprise_boundary(C4L3Parser.Enterprise_boundaryContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterPerson(C4L1Parser.PersonContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterPerson(C4L2Parser.PersonContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterPerson(C4L3Parser.PersonContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterPerson_ext(C4L1Parser.Person_extContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterPerson_ext(C4L2Parser.Person_extContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterPerson_ext(C4L3Parser.Person_extContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterSystem(C4L1Parser.SystemContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterSystem(C4L2Parser.SystemContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterSystem(C4L3Parser.SystemContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterSystem_boundary(C4L2Parser.System_boundaryContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterSystem_ext(C4L1Parser.System_extContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterSystem_ext(C4L2Parser.System_extContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    public void enterSystem_ext(C4L3Parser.System_extContext ctx) {
        this.checkAliasIsUnique(ctx.Alias());
    }

    private void checkAliasIsUnique(TerminalNode alias) {
        if (this.aliases.contains(alias.getText())) {
            String message = String.format("Alias '%s' is declared multiple times", alias);
            this.reporter.report(message);
            this.rule.getLogger().error(message);
        }
        this.aliases.add(alias.getText());
    }
}

