/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.linter.rules.builtin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.thewonderlemming.c4plantuml.commons.Reporter;
import org.thewonderlemming.c4plantuml.grammars.C4BaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;

public class NoDuplicateRelationshipsListener
extends C4BaseListener {
    private static final String MESSAGE_FORMAT = "Duplicate relationship found for <'%s' -> '%s': '%s'>";
    private final Set<String> declaredRelationShips = new HashSet<String>();
    private final Reporter reporter;

    public NoDuplicateRelationshipsListener(Reporter reporter) {
        this.reporter = reporter;
    }

    public void enterRelationship(C4L1Parser.RelationshipContext ctx) {
        List aliases = ctx.Alias();
        TerminalNode sourceAlias = (TerminalNode)aliases.get(0);
        TerminalNode targetAlias = (TerminalNode)aliases.get(1);
        TerminalNode label = ctx.String();
        this.checkRelationshipIsUnique(sourceAlias, targetAlias, label);
    }

    public void enterRelationship(C4L2Parser.RelationshipContext ctx) {
        List aliases = ctx.Alias();
        TerminalNode sourceAlias = (TerminalNode)aliases.get(0);
        TerminalNode targetAlias = (TerminalNode)aliases.get(1);
        TerminalNode label = ctx.String(0);
        this.checkRelationshipIsUnique(sourceAlias, targetAlias, label);
    }

    public void enterRelationship(C4L3Parser.RelationshipContext ctx) {
        List aliases = ctx.Alias();
        TerminalNode sourceAlias = (TerminalNode)aliases.get(0);
        TerminalNode targetAlias = (TerminalNode)aliases.get(1);
        TerminalNode label = ctx.String(0);
        this.checkRelationshipIsUnique(sourceAlias, targetAlias, label);
    }

    private String buildErrorMessage(TerminalNode sourceAlias, TerminalNode targetAlias, TerminalNode label) {
        return String.format(MESSAGE_FORMAT, sourceAlias.getText(), targetAlias.getText(), label.getText());
    }

    private void checkRelationshipIsUnique(TerminalNode sourceAlias, TerminalNode targetAlias, TerminalNode label) {
        String relationship = this.convertRelationshipToString(sourceAlias, targetAlias, label);
        if (this.declaredRelationShips.contains(relationship)) {
            String errorMessage = this.buildErrorMessage(sourceAlias, targetAlias, label);
            this.reporter.report(errorMessage);
        } else {
            this.declaredRelationShips.add(relationship);
        }
    }

    private String convertRelationshipToString(TerminalNode sourceAlias, TerminalNode targetAlias, TerminalNode label) {
        return sourceAlias.getText() + targetAlias.getText() + label.getText();
    }
}

