package org.thewonderlemming.c4plantuml.mojo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.thewonderlemming.c4plantuml.commons.Reporter;

/**
 * A {@link Reporter} implementation that collects reported messages to enable their retrieval later.
 *
 * @author thewonderlemming
 *
 */
public class MojoReporter implements Reporter {

    private final List<String> reports = Collections.synchronizedList(new ArrayList<>());


    /**
     * Checks whether or not the current {@link Reporter} instance contains messages.
     *
     * @return {@code true} if there are messages, {@code false} else.
     */
    public boolean containsReports() {
        return !this.reports.isEmpty();
    }

    /**
     * Retrieves the reported messages.
     * <p>
     * The first message of the list will be the first message that was reported (FIFO).
     *
     * @return the reported messages list.
     */
    public List<String> getReports() {
        return this.reports;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void report(final String message) {
        this.reports.add(message);
    }
}
