package org.thewonderlemming.c4plantuml.mojo.linting;

import org.thewonderlemming.c4plantuml.mojo.linting.rules.custom.AbstractCustomLintingRule;

/**
 * A POJO to enforce typing for {@link AbstractCustomLintingRule} in the {@code pom.xml} file.
 *
 * @author thewonderlemming
 *
 */
public class BuiltInRules {

    private AliasesShouldBeListedInDictionary aliasesShouldBeListedInDictionary;

    private AliasesShouldBeUnique aliasesShouldBeUnique;

    private AliasesShouldFollowStandardConvention aliasesShouldFollowStandardConvention;

    private NoDuplicateRelationships noDuplicateRelationships;

    private NoOrphanAliasInBoundaries noOrphanAliasInBoundaries;

    private NoOrphanAliasInLayouts noOrphanAliasInLayouts;

    private NoOrphanAliasInRelationships noOrphanAliasInRelationships;


    /**
     * Default constructor. Ensures that there won't be any {@link NullPointerException}.
     */
    public BuiltInRules() {

        this.aliasesShouldBeListedInDictionary = new AliasesShouldBeListedInDictionary();
        this.aliasesShouldFollowStandardConvention = new AliasesShouldFollowStandardConvention();
        this.noOrphanAliasInRelationships = new NoOrphanAliasInRelationships();
        this.aliasesShouldBeUnique = new AliasesShouldBeUnique();
        this.noDuplicateRelationships = new NoDuplicateRelationships();
        this.noOrphanAliasInLayouts = new NoOrphanAliasInLayouts();
        this.noOrphanAliasInBoundaries = new NoOrphanAliasInBoundaries();
    }

    /**
     * A simple getter for the {@code aliasesShouldBeListedInDictionary} property.
     *
     * @return the value of the {@code aliasesShouldBeListedInDictionary} property.
     */
    public AliasesShouldBeListedInDictionary getAliasesShouldBeListedInDictionary() {
        return aliasesShouldBeListedInDictionary;
    }

    /**
     * A simple getter for the {@code aliasesShouldBeUnique} property.
     *
     * @return the value of the {@code aliasesShouldBeUnique} property.
     */
    public AliasesShouldBeUnique getAliasesShouldBeUnique() {
        return aliasesShouldBeUnique;
    }

    /**
     * A simple getter for the {@code aliasesShouldFollowStandardConvention} property.
     *
     * @return the value of the {@code aliasesShouldFollowStandardConvention} property.
     */
    public AliasesShouldFollowStandardConvention getAliasesShouldFollowStandardConvention() {
        return aliasesShouldFollowStandardConvention;
    }

    /**
     * A simple getter for the {@code noDuplicateRelationships} property.
     *
     * @return the value of the {@code noDuplicateRelationships} property.
     */
    public NoDuplicateRelationships getNoDuplicateRelationships() {
        return noDuplicateRelationships;
    }

    /**
     * A simple getter for the {@code noOrphanAliasInBoundaries} property.
     *
     * @return the value of the {@code noOrphanAliasInBoundaries} property.
     */
    public NoOrphanAliasInBoundaries getNoOrphanAliasInBoundaries() {
        return noOrphanAliasInBoundaries;
    }

    /**
     * A simple getter for the {@code noOrphanAliasInLayouts} property.
     *
     * @return the value of the {@code noOrphanAliasInLayouts} property.
     */
    public NoOrphanAliasInLayouts getNoOrphanAliasInLayouts() {
        return noOrphanAliasInLayouts;
    }

    /**
     * A simple getter for the {@code noOrphanAliasInRelationships} property.
     *
     * @return the value of the {@code noOrphanAliasInRelationships} property.
     */
    public NoOrphanAliasInRelationships getNoOrphanAliasInRelationships() {
        return noOrphanAliasInRelationships;
    }

    /**
     * A simple setter for the {@code aliasesShouldBeListedInDictionary} property.
     *
     * @param aliasesShouldBeListedInDictionary the value to set.
     */
    public void setAliasesShouldBeListedInDictionary(
        final AliasesShouldBeListedInDictionary aliasesShouldBeListedInDictionary) {
        this.aliasesShouldBeListedInDictionary = aliasesShouldBeListedInDictionary;
    }

    /**
     * A simple setter for the {@code aliasesShouldBeUnique} property.
     *
     * @param aliasesShouldBeUnique the value to set.
     */
    public void setAliasesShouldBeUnique(final AliasesShouldBeUnique aliasesShouldBeUnique) {
        this.aliasesShouldBeUnique = aliasesShouldBeUnique;
    }

    /**
     * A simple setter for the {@code aliasesShouldFollowStandardConvention} property.
     *
     * @param aliasesShouldFollowStandardConvention the value to set.
     */
    public void setAliasesShouldFollowStandardConvention(
        final AliasesShouldFollowStandardConvention aliasesShouldFollowStandardConvention) {
        this.aliasesShouldFollowStandardConvention = aliasesShouldFollowStandardConvention;
    }

    /**
     * A simple setter for the {@code noDuplicateRelationships} property.
     *
     * @param noDuplicateRelationships the value to set.
     */
    public void setNoDuplicateRelationships(final NoDuplicateRelationships noDuplicateRelationships) {
        this.noDuplicateRelationships = noDuplicateRelationships;
    }

    /**
     * A simple setter for the {@code noOrphanAliasInBoundaries} property.
     *
     * @param noOrphanAliasInBoundaries the value to set.
     */
    public void setNoOrphanAliasInBoundaries(final NoOrphanAliasInBoundaries noOrphanAliasInBoundaries) {
        this.noOrphanAliasInBoundaries = noOrphanAliasInBoundaries;
    }

    /**
     * A simple setter for the {@code noOrphanAliasInLayouts} property.
     *
     * @param noOrphanAliasInLayouts the value to set.
     */
    public void setNoOrphanAliasInLayouts(final NoOrphanAliasInLayouts noOrphanAliasInLayouts) {
        this.noOrphanAliasInLayouts = noOrphanAliasInLayouts;
    }

    /**
     * A simple setter for the {@code noOrphanAliasInRelationships} property.
     *
     * @param noOrphanAliasInRelationships the value to set.
     */
    public void setNoOrphanAliasInRelationships(final NoOrphanAliasInRelationships noOrphanAliasInRelationships) {
        this.noOrphanAliasInRelationships = noOrphanAliasInRelationships;
    }
}
