package org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.thewonderlemming.c4plantuml.linter.rules.builtin.AliasesShouldBeListedInDictionaryRule;
import org.thewonderlemming.c4plantuml.mojo.linting.AliasesShouldBeListedInDictionary;
import org.thewonderlemming.c4plantuml.mojo.linting.BuiltInRules;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.AbstractRuleParametersFactory;

/**
 * An implementation of {@link AbstractRuleParametersFactory} for the {@link AliasesShouldBeListedInDictionaryRule}.
 *
 * @author thewonderlemming
 *
 */
public class AliasesShouldBeListedInDictionaryRuleParametersFactory
    extends AbstractRuleParametersFactory<AliasesShouldBeListedInDictionary> {

    /**
     * Default constructor.
     *
     * @param mojoParameters the POJO that contains the {@code pom.xml} configuration.
     */
    public AliasesShouldBeListedInDictionaryRuleParametersFactory(final BuiltInRules mojoParameters) {
        super(mojoParameters);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean getActivatedParameter(final AliasesShouldBeListedInDictionary pojoParameters) {
        return pojoParameters.isActivated();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected AliasesShouldBeListedInDictionary getPojoFromBuiltInRules(final BuiltInRules mojoParameters) {
        return mojoParameters.getAliasesShouldBeListedInDictionary();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Set<String> getRuleParametersKeys() {

        return Stream
            .of(AliasesShouldBeListedInDictionaryRule.getAliasDictionaryFilenameParameterName())
                .collect(Collectors.toSet());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Optional<String> getValueForParameter(final String key,
        final AliasesShouldBeListedInDictionary pojoParameters) {

        if (AliasesShouldBeListedInDictionaryRule.getAliasDictionaryFilenameParameterName().equals(key)) {
            return Optional.ofNullable(pojoParameters.getAliasDictionaryFilename());
        }

        return Optional.empty();
    }
}
