package org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;

import org.thewonderlemming.c4plantuml.linter.rules.builtin.AliasesShouldBeUniqueRule;
import org.thewonderlemming.c4plantuml.mojo.linting.AliasesShouldBeUnique;
import org.thewonderlemming.c4plantuml.mojo.linting.BuiltInRules;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.AbstractRuleParametersFactory;

/**
 * An implementation of {@link AbstractRuleParametersFactory} for the {@link AliasesShouldBeUniqueRule}.
 *
 * @author thewonderlemming
 *
 */
public class AliasesShouldBeUniqueRuleParametersFactory
    extends AbstractRuleParametersFactory<AliasesShouldBeUnique> {

    /**
     * Default constructor.
     *
     * @param mojoParameters the PJO that contains the {@code pom.xml} configuration.
     */
    public AliasesShouldBeUniqueRuleParametersFactory(final BuiltInRules mojoParameters) {
        super(mojoParameters);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean getActivatedParameter(final AliasesShouldBeUnique pojoParameters) {
        return pojoParameters.isActivated();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected AliasesShouldBeUnique getPojoFromBuiltInRules(final BuiltInRules mojoParameters) {
        return mojoParameters.getAliasesShouldBeUnique();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Set<String> getRuleParametersKeys() {
        return Collections.emptySet();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Optional<String> getValueForParameter(final String key, final AliasesShouldBeUnique pojoParameters) {
        return Optional.empty();
    }
}
