package org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.thewonderlemming.c4plantuml.linter.rules.builtin.AliasesShouldFollowStandardConventionRule;
import org.thewonderlemming.c4plantuml.mojo.linting.AliasesShouldFollowStandardConvention;
import org.thewonderlemming.c4plantuml.mojo.linting.BuiltInRules;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.AbstractRuleParametersFactory;

/**
 * An implementation of {@link AbstractRuleParametersFactory} for the {@link AliasesShouldFollowStandardConventionRule}.
 *
 * @author thewonderlemming
 *
 */
public class AliasesShouldFollowStandardConventionRuleParametersFactory
    extends AbstractRuleParametersFactory<AliasesShouldFollowStandardConvention> {

    /**
     * Default constructor.
     *
     * @param mojoParameters the PJO that contains the {@code pom.xml} configuration.
     */
    public AliasesShouldFollowStandardConventionRuleParametersFactory(final BuiltInRules mojoParameters) {
        super(mojoParameters);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean getActivatedParameter(final AliasesShouldFollowStandardConvention pojoParameters) {
        return pojoParameters.isActivated();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected AliasesShouldFollowStandardConvention getPojoFromBuiltInRules(final BuiltInRules mojoParameters) {
        return mojoParameters.getAliasesShouldFollowStandardConvention();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Set<String> getRuleParametersKeys() {

        return Stream
            .of(AliasesShouldFollowStandardConventionRule.getAliasFormatParameterName())
                .collect(Collectors.toSet());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Optional<String> getValueForParameter(final String key,
        final AliasesShouldFollowStandardConvention pojoParameters) {

        if (AliasesShouldFollowStandardConventionRule.getAliasFormatParameterName().equals(key)) {
            return Optional.ofNullable(pojoParameters.getAliasDefaultFormatRegex());
        }

        return Optional.empty();
    }
}
