package org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;

import org.thewonderlemming.c4plantuml.linter.rules.builtin.NoDuplicateRelationshipsRule;
import org.thewonderlemming.c4plantuml.mojo.linting.BuiltInRules;
import org.thewonderlemming.c4plantuml.mojo.linting.NoDuplicateRelationships;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.AbstractRuleParametersFactory;

/**
 * An implementation of {@link AbstractRuleParametersFactory} for the {@link NoDuplicateRelationshipsRule}.
 *
 * @author thewonderlemming
 *
 */
public class NoDuplicateRelationshipsRuleParametersFactory
    extends AbstractRuleParametersFactory<NoDuplicateRelationships> {

    /**
     * Default constructor.
     *
     * @param mojoParameters the POJO that contains the {@code pom.xml} configuration.
     */
    public NoDuplicateRelationshipsRuleParametersFactory(final BuiltInRules mojoParameters) {
        super(mojoParameters);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean getActivatedParameter(final NoDuplicateRelationships pojoParameters) {
        return pojoParameters.isActivated();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected NoDuplicateRelationships getPojoFromBuiltInRules(final BuiltInRules mojoParameters) {
        return mojoParameters.getNoDuplicateRelationships();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Set<String> getRuleParametersKeys() {
        return Collections.emptySet();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Optional<String> getValueForParameter(final String key, final NoDuplicateRelationships pojoParameters) {
        return Optional.empty();
    }
}
