package org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;

import org.thewonderlemming.c4plantuml.linter.rules.builtin.NoOrphanAliasInBoundariesRule;
import org.thewonderlemming.c4plantuml.mojo.linting.BuiltInRules;
import org.thewonderlemming.c4plantuml.mojo.linting.NoOrphanAliasInBoundaries;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.AbstractRuleParametersFactory;

/**
 * An implementation of {@link AbstractRuleParametersFactory} for the {@link NoOrphanAliasInBoundariesRule}.
 *
 * @author thewonderlemming
 *
 */
public class NoOrphanAliasInBoundariesRuleParametersFactory
    extends AbstractRuleParametersFactory<NoOrphanAliasInBoundaries> {

    /**
     * Default constructor.
     *
     * @param mojoParameters the POJO that contains the {@code pom.xml} configuration.
     */
    public NoOrphanAliasInBoundariesRuleParametersFactory(final BuiltInRules mojoParameters) {
        super(mojoParameters);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean getActivatedParameter(final NoOrphanAliasInBoundaries mpjoParameters) {
        return mpjoParameters.isActivated();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected NoOrphanAliasInBoundaries getPojoFromBuiltInRules(final BuiltInRules mojoParameters) {
        return mojoParameters.getNoOrphanAliasInBoundaries();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Set<String> getRuleParametersKeys() {
        return Collections.emptySet();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Optional<String> getValueForParameter(final String key, final NoOrphanAliasInBoundaries pojoParameters) {
        return Optional.empty();
    }
}
