package org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;

import org.thewonderlemming.c4plantuml.linter.rules.builtin.NoOrphanAliasInLayoutsRule;
import org.thewonderlemming.c4plantuml.mojo.linting.BuiltInRules;
import org.thewonderlemming.c4plantuml.mojo.linting.NoOrphanAliasInLayouts;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.AbstractRuleParametersFactory;

/**
 * An implementation of {@link AbstractRuleParametersFactory} for the {@link NoOrphanAliasInLayoutsRule}.
 *
 * @author thewonderlemming
 *
 */
public class NoOrphanAliasInLayoutsRuleParametersFactory
    extends AbstractRuleParametersFactory<NoOrphanAliasInLayouts> {

    /**
     * Default constructor.
     *
     * @param mojoParameters the POJO that contains the {@code pom.xml} configuration.
     */
    public NoOrphanAliasInLayoutsRuleParametersFactory(final BuiltInRules mojoParameters) {
        super(mojoParameters);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean getActivatedParameter(final NoOrphanAliasInLayouts pojoParameters) {
        return pojoParameters.isActivated();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected NoOrphanAliasInLayouts getPojoFromBuiltInRules(final BuiltInRules mojoParameters) {
        return mojoParameters.getNoOrphanAliasInLayouts();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Set<String> getRuleParametersKeys() {
        return Collections.emptySet();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Optional<String> getValueForParameter(final String key, final NoOrphanAliasInLayouts pojoParameters) {
        return Optional.empty();
    }
}
