package org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.parameters;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;

import org.thewonderlemming.c4plantuml.linter.rules.builtin.NoOrphanAliasInRelationshipsRule;
import org.thewonderlemming.c4plantuml.mojo.linting.BuiltInRules;
import org.thewonderlemming.c4plantuml.mojo.linting.NoOrphanAliasInRelationships;
import org.thewonderlemming.c4plantuml.mojo.linting.rules.builtin.AbstractRuleParametersFactory;

/**
 * An implementation of {@link AbstractRuleParametersFactory} for the {@link NoOrphanAliasInRelationshipsRule}.
 *
 * @author thewonderlemming
 *
 */
public class NoOrphanAliasInRelationshipsRuleParametersFactory
    extends AbstractRuleParametersFactory<NoOrphanAliasInRelationships> {

    /**
     * Default constructor.
     *
     * @param mojoParameters the POJO that contains the {@code pom.xml} configuration.
     */
    public NoOrphanAliasInRelationshipsRuleParametersFactory(final BuiltInRules mojoParameters) {
        super(mojoParameters);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean getActivatedParameter(final NoOrphanAliasInRelationships pojoParameters) {
        return pojoParameters.isActivated();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected NoOrphanAliasInRelationships getPojoFromBuiltInRules(final BuiltInRules mojoParameters) {
        return mojoParameters.getNoOrphanAliasInRelationships();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Set<String> getRuleParametersKeys() {
        return Collections.emptySet();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Optional<String> getValueForParameter(final String key,
        final NoOrphanAliasInRelationships mojoParameters) {
        return Optional.empty();
    }
}
