package org.thewonderlemming.c4plantuml.mojo.linting.rules.custom;

import org.thewonderlemming.c4plantuml.linter.rules.AbstractLintingRule;
import org.thewonderlemming.c4plantuml.linter.rules.RuleParameters;

/**
 * A base class to build custom {@link AbstractLintingRule}.
 * <p>
 * Extend the following class if you intend to create your own rules but don't want to integrate them to the current
 * plugin.
 * <p>
 * Please not that you'll also have to implement a {@link AbstractCustomLintingRuleFactory}.
 *
 * @see AbstractCustomLintingRuleFactory
 *
 * @author thewonderlemming
 *
 */
public abstract class AbstractCustomLintingRule extends AbstractLintingRule {

    /**
     * Creates the custom rule, given its parameters.
     *
     * @param parameters the custom rule {@link RuleParameters}.
     */
    protected AbstractCustomLintingRule(final RuleParameters parameters) {
        super(parameters);
    }
}
